/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.pillar;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VerticalRelicstonePillarFeature
extends Feature<NoneFeatureConfiguration> {
    public VerticalRelicstonePillarFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        int height = random.nextIntBetweenInclusive(2, 4);
        int offset = 0;
        this.placeHead(level, origin, Direction.UP);
        for (int i = 1; i <= height; ++i) {
            this.placePillar(level, origin.above(++offset), Direction.UP);
        }
        this.placeHead(level, origin.above(++offset), Direction.DOWN);
        return true;
    }

    public void placeHead(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeHead(pLevel, pPos, pDirection);
        }
    }

    public void placeHead(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection) {
        if (pLevel.getBlockState(pPos).isAir() && (pLevel.getBlockState(pPos.below()).is(IcariaBlockTags.DIRT_AND_SAND) || pLevel.getBlockState(pPos.below()).is((Block)IcariaBlocks.RELICSTONE_PILLAR.get()))) {
            this.setBlock((LevelWriter)pLevel, pPos, (BlockState)IcariaBlocks.RELICSTONE_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)pDirection));
        }
    }

    public void placePillar(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placePillar(pLevel, pPos, pDirection);
        }
    }

    public void placePillar(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection) {
        if (pLevel.getBlockState(pPos).isAir() && (pLevel.getBlockState(pPos.below()).is((Block)IcariaBlocks.RELICSTONE_PILLAR.get()) || pLevel.getBlockState(pPos.below()).is(IcariaBlocks.RELICSTONE_PILLAR_HEAD.get()))) {
            this.setBlock((LevelWriter)pLevel, pPos, (BlockState)IcariaBlocks.RELICSTONE_PILLAR.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)pDirection.getAxis()));
        }
    }
}

