/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.tree;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.world.feature.tree.IcariaTreeFeature;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DroughtrootTreeFeature
extends IcariaTreeFeature {
    public DroughtrootTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec, IcariaBlocks.FALLEN_DROUGHTROOT_LEAVES.get(), IcariaBlocks.DROUGHTROOT_LEAVES.get(), (Block)IcariaBlocks.DROUGHTROOT_LOG.get(), IcariaBlocks.UNNAMED_TREE_SHROOMS.get(), IcariaBlocks.DROUGHTROOT_TWIGS.get());
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        int heightUpper;
        int heightInner;
        int heightLower;
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int heightTrunk = random.nextIntBetweenInclusive(2, 4);
        int heightTotal = heightTrunk + (heightLower = random.nextIntBetweenInclusive(1, 4)) + (heightInner = random.nextIntBetweenInclusive(1, 4)) + (heightUpper = random.nextIntBetweenInclusive(1, 4));
        int heightAxisY = heightTotal + origin.getY();
        if (heightAxisY < level.getMaxBuildHeight() && level.getBlockState(origin.atY(heightAxisY)).canBeReplaced()) {
            int i;
            for (i = 1; i <= heightTrunk; ++i) {
                this.placeLog(level, origin.below().above(i), Direction.Axis.Y);
            }
            for (i = 1; i <= heightLower; ++i) {
                direction = direction.getOpposite();
                this.placeLog(level, origin.below().above(++heightTrunk), Direction.Axis.Y);
                this.placeLog(level, origin.below().above(heightTrunk).relative(direction), direction.getAxis());
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction), 2);
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction.getClockWise()));
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction.getCounterClockWise()));
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction).relative(direction.getClockWise()));
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction).relative(direction.getCounterClockWise()));
            }
            for (i = 1; i <= heightInner; ++i) {
                direction = direction.getOpposite();
                this.placeLog(level, origin.below().above(++heightTrunk), Direction.Axis.Y);
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction));
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction.getClockWise()));
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction.getCounterClockWise()));
            }
            for (i = 1; i <= heightUpper; ++i) {
                direction = direction.getOpposite();
                this.placeLeaves(level, origin.below().above(++heightTrunk));
                this.placeLeaves(level, origin.below().above(heightTrunk).relative(direction));
            }
            this.placeTwigsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeFallenPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeShroomsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            return true;
        }
        return false;
    }
}

