/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.tree;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.world.feature.tree.IcariaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LaurelTreeFeature
extends IcariaTreeFeature {
    public LaurelTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec, IcariaBlocks.FALLEN_LAUREL_LEAVES.get(), IcariaBlocks.LAUREL_LEAVES.get(), (Block)IcariaBlocks.LAUREL_LOG.get(), IcariaBlocks.TINDER_FUNGUS_TREE_SHROOMS.get(), IcariaBlocks.LAUREL_TWIGS.get());
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        int branchCount = random.nextIntBetweenInclusive(2, 3);
        int heightTrunk = random.nextIntBetweenInclusive(1, 4);
        int heightLimit = heightTrunk + 4;
        int heightAxisY = heightLimit + origin.getY();
        if (heightAxisY < level.getMaxBuildHeight() && level.getBlockState(origin.atY(heightAxisY)).canBeReplaced()) {
            int i;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                directions.add(direction);
            }
            for (i = 1; i <= heightTrunk; ++i) {
                this.placeLog(level, origin.below().above(i), Direction.Axis.Y);
            }
            for (i = 1; i <= branchCount; ++i) {
                Direction direction;
                direction = (Direction)directions.get(random.nextInt(directions.size()));
                Direction clockWise = direction.getClockWise();
                BlockPos blockPos = new BlockPos((Vec3i)origin.below().above(heightTrunk));
                int length = random.nextIntBetweenInclusive(4, 6);
                directions.remove(direction);
                for (int j = 1; j <= length; ++j) {
                    blockPos = blockPos.above();
                    if (random.nextInt(j * 2 + 1) == 0) {
                        blockPos = blockPos.relative(direction);
                    }
                    if (random.nextInt(j * 2 + 3) == 0) {
                        blockPos = blockPos.relative(clockWise);
                    }
                    this.placeLog(level, blockPos, Direction.Axis.Y);
                    this.placeLeaves(level, blockPos.above());
                    this.placeLeaves(level, blockPos.north());
                    this.placeLeaves(level, blockPos.east());
                    this.placeLeaves(level, blockPos.south());
                    this.placeLeaves(level, blockPos.west());
                    this.placeLeaves(level, blockPos.below());
                }
            }
            this.placeTwigsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeFallenPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeShroomsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            return true;
        }
        return false;
    }
}

