/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.tree;

import com.axanthic.icaria.common.properties.Olives;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.world.feature.tree.IcariaTreeFeature;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OliveTreeFeature
extends IcariaTreeFeature {
    public OliveTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec, IcariaBlocks.FALLEN_OLIVE_LEAVES.get(), IcariaBlocks.OLIVE_LEAVES.get(), (Block)IcariaBlocks.OLIVE_LOG.get(), IcariaBlocks.UNNAMED_TREE_SHROOMS.get(), IcariaBlocks.OLIVE_TWIGS.get());
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int heightTrunk = random.nextIntBetweenInclusive(1, 2);
        int heightLimit = heightTrunk + 4;
        int heightAxisY = heightLimit + origin.getY();
        if (heightAxisY < level.getMaxBuildHeight() && level.getBlockState(origin.atY(heightAxisY)).canBeReplaced()) {
            for (int i = 1; i <= heightTrunk; ++i) {
                this.placeLog(level, origin.below().above(i), Direction.Axis.Y);
            }
            this.placeLog(level, origin.below().above(++heightTrunk), Direction.Axis.Y);
            this.placeLeaves(level, origin.below().above(heightTrunk).north());
            this.placeLeaves(level, origin.below().above(heightTrunk).east());
            this.placeLeaves(level, origin.below().above(heightTrunk).south());
            this.placeLeaves(level, origin.below().above(heightTrunk).west());
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).north().east());
            this.placeLeaves(level, origin.below().above(heightTrunk).east().south());
            this.placeLeaves(level, origin.below().above(heightTrunk).south().west());
            this.placeLeaves(level, origin.below().above(heightTrunk).west().north());
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2).east(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2).south(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2).west(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2).north(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2).west(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2).north(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2).east(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2).south(), 2);
            this.placeLog(level, origin.below().above(++heightTrunk), Direction.Axis.Y);
            this.placeLeaves(level, origin.below().above(heightTrunk).north());
            this.placeLeaves(level, origin.below().above(heightTrunk).east());
            this.placeLeaves(level, origin.below().above(heightTrunk).south());
            this.placeLeaves(level, origin.below().above(heightTrunk).west());
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2));
            this.placeLeaves(level, origin.below().above(heightTrunk).north(3));
            this.placeLeaves(level, origin.below().above(heightTrunk).east(3));
            this.placeLeaves(level, origin.below().above(heightTrunk).south(3));
            this.placeLeaves(level, origin.below().above(heightTrunk).west(3));
            this.placeLeaves(level, origin.below().above(heightTrunk).north().east());
            this.placeLeaves(level, origin.below().above(heightTrunk).east().south());
            this.placeLeaves(level, origin.below().above(heightTrunk).south().west());
            this.placeLeaves(level, origin.below().above(heightTrunk).west().north());
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2).east());
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2).south());
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2).west());
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2).north());
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2).west());
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2).north());
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2).east());
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2).south());
            this.placeLeaves(level, origin.below().above(heightTrunk).north(3).east(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).east(3).south(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).south(3).west(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).west(3).north(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).north(3).west(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).east(3).north(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).south(3).east(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).west(3).south(), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).north(2).west(2), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).east(2).north(2), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).south(2).east(2), 2);
            this.placeLeaves(level, origin.below().above(heightTrunk).west(2).south(2), 2);
            this.placeLog(level, origin.relative(direction).below().above(++heightTrunk), Direction.Axis.Y);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north().east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east().south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south().west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west().north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(3).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(3).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(3).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(3).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(3).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(3).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(3).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(3).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).west(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).north(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).east(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).south(2));
            this.placeLog(level, origin.relative(direction).below().above(++heightTrunk), Direction.Axis.Y);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(3));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north().east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east().south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south().west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west().north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(3).east(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(3).south(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(3).west(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(3).north(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(3).west(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(3).north(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(3).east(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(3).south(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).west(2), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).north(2), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).east(2), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).south(2), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(++heightTrunk));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north().east());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east().south());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south().west());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west().north());
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).east(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).south(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).west(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).north(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(2).west(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(2).north(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(2).east(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(2).south(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(++heightTrunk));
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).north(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).east(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).south(), 2);
            this.placeLeaves(level, origin.relative(direction).below().above(heightTrunk).west(), 2);
            this.placeTwigsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeFallenPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeShroomsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            return true;
        }
        return false;
    }

    @Override
    public void placeLeaves(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir()) {
            if (pLevel.getRandom().nextBoolean()) {
                if (pLevel.getRandom().nextInt(3) == 0) {
                    this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.leaves.defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.NONE)));
                } else if (pLevel.getRandom().nextInt(3) == 1) {
                    this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.leaves.defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.GREEN)));
                } else if (pLevel.getRandom().nextInt(3) == 2) {
                    this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.leaves.defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.BLACK)));
                }
            } else {
                this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.leaves.defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.LEAVES)));
            }
        }
    }
}

