/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.tree;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.world.feature.tree.IcariaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlaneTreeFeature
extends IcariaTreeFeature {
    public PlaneTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec, IcariaBlocks.FALLEN_PLANE_LEAVES.get(), IcariaBlocks.PLANE_LEAVES.get(), (Block)IcariaBlocks.PLANE_LOG.get(), IcariaBlocks.TURKEY_TAIL_TREE_SHROOMS.get(), IcariaBlocks.PLANE_TWIGS.get());
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        int branchCount = random.nextIntBetweenInclusive(2, 3);
        int heightTrunk = random.nextIntBetweenInclusive(1, 4);
        int heightLimit = heightTrunk + 4;
        int heightAxisY = heightLimit + origin.getY();
        if (heightAxisY < level.getMaxBuildHeight() && level.getBlockState(origin.atY(heightAxisY)).canBeReplaced()) {
            int i;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                directions.add(direction);
            }
            for (i = 1; i <= heightTrunk; ++i) {
                this.placeLog(level, origin.below().above(i), Direction.Axis.Y);
            }
            for (i = 1; i <= branchCount; ++i) {
                Direction front = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                Direction right = front.getClockWise();
                Direction back = front.getOpposite();
                Direction left = front.getCounterClockWise();
                Direction direction = (Direction)directions.get(random.nextInt(directions.size()));
                Direction clockWise = direction.getClockWise();
                BlockPos blockPos = new BlockPos((Vec3i)origin.below().above(heightTrunk));
                int length = random.nextIntBetweenInclusive(2, 4);
                directions.remove(direction);
                for (int j = 1; j <= length; ++j) {
                    blockPos = blockPos.relative(direction);
                    if (random.nextInt(3) == 0) {
                        blockPos = blockPos.relative(clockWise);
                    }
                    if (random.nextInt(3) != 0) {
                        blockPos = blockPos.above();
                    }
                    this.placeLog(level, blockPos, direction.getAxis());
                }
                this.placeLeaves(level, blockPos.relative(front).relative(right), 2);
                this.placeLeaves(level, blockPos.relative(back).relative(left), 2);
                this.placeLeaves(level, blockPos.north());
                this.placeLeaves(level, blockPos.east());
                this.placeLeaves(level, blockPos.south());
                this.placeLeaves(level, blockPos.west());
                this.placeLeaves(level, blockPos.above());
                this.placeLeaves(level, blockPos.above().relative(front), 2);
                this.placeLeaves(level, blockPos.above().relative(front).relative(right), 4);
                this.placeLeaves(level, blockPos.above().relative(right), 2);
                this.placeLeaves(level, blockPos.below());
                this.placeLeaves(level, blockPos.below().relative(back), 2);
                this.placeLeaves(level, blockPos.below().relative(back).relative(left), 4);
                this.placeLeaves(level, blockPos.below().relative(left), 2);
            }
            this.placeTwigsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeFallenPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            this.placeShroomsPatch(level, origin, random.nextIntBetweenInclusive(8, 16));
            return true;
        }
        return false;
    }
}

