/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.vine;

import com.axanthic.icaria.common.block.IcariaVineBlock;
import com.axanthic.icaria.common.properties.Vine;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.world.feature.vine.IcariaVineFeature;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BrushyVineFeature
extends IcariaVineFeature {
    public BrushyVineFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec, IcariaBlocks.BRUSHY_VINE.get());
    }

    @Override
    public void placeVine(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection) {
        if (pLevel.getBlockState(pPos).isAir() && (pLevel.getBlockState(pPos.relative(pDirection)).is(BlockTags.LEAVES) || pLevel.getBlockState(pPos.relative(pDirection)).isSolidRender((BlockGetter)pLevel, pPos.relative(pDirection))) && IcariaVineBlock.isAcceptableNeighbour((BlockGetter)pLevel, pPos.relative(pDirection), pDirection)) {
            if (pLevel.getRandom().nextBoolean()) {
                if (pLevel.getRandom().nextInt(2) == 0) {
                    this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.vine.defaultBlockState().setValue((Property)IcariaVineBlock.getPropForFace(pDirection), (Comparable)Boolean.valueOf(true))).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.NONE)));
                } else if (pLevel.getRandom().nextInt(2) == 1) {
                    this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.vine.defaultBlockState().setValue((Property)IcariaVineBlock.getPropForFace(pDirection), (Comparable)Boolean.valueOf(true))).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.RIPE)));
                }
            } else {
                this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.vine.defaultBlockState().setValue((Property)IcariaVineBlock.getPropForFace(pDirection), (Comparable)Boolean.valueOf(true))).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.VINE)));
            }
        }
    }
}

