/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.vine;

import com.axanthic.icaria.common.block.IcariaVineBlock;
import com.axanthic.icaria.common.properties.Vine;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaVineFeature
extends Feature<NoneFeatureConfiguration> {
    public Block vine;

    public IcariaVineFeature(Codec<NoneFeatureConfiguration> pCodec, Block pVine) {
        super(pCodec);
        this.vine = pVine;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.placeVine(level, origin, direction);
        }
        return true;
    }

    public void placeVine(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeVine(pLevel, pPos, pDirection);
        }
    }

    public void placeVine(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection) {
        if (pLevel.getBlockState(pPos).isAir() && (pLevel.getBlockState(pPos.relative(pDirection)).is(BlockTags.LEAVES) || pLevel.getBlockState(pPos.relative(pDirection)).isSolidRender((BlockGetter)pLevel, pPos.relative(pDirection))) && IcariaVineBlock.isAcceptableNeighbour((BlockGetter)pLevel, pPos.relative(pDirection), pDirection)) {
            if (pLevel.getRandom().nextBoolean()) {
                this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.vine.defaultBlockState().setValue((Property)IcariaVineBlock.getPropForFace(pDirection), (Comparable)Boolean.valueOf(true))).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.NONE)));
            } else {
                this.setBlock((LevelWriter)pLevel, pPos, (BlockState)((BlockState)this.vine.defaultBlockState().setValue((Property)IcariaVineBlock.getPropForFace(pDirection), (Comparable)Boolean.valueOf(true))).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.VINE)));
            }
        }
    }
}

