/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.structure;

import com.axanthic.icaria.common.registry.IcariaStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaJigsawStructure
extends Structure {
    public boolean useExpansionHack;
    public int maxDepth;
    public int maxDistanceFromCenter;
    public DimensionPadding dimensionPadding;
    public HeightProvider minHeight;
    public HeightProvider maxHeight;
    public Holder<StructureTemplatePool> startPool;
    public LiquidSettings liquidSettings;
    public List<PoolAliasBinding> poolAliases;
    public static final MapCodec<IcariaJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(pInstance -> pInstance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)pInstance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(pStructure -> pStructure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(pStructure -> pStructure.startJigsawName), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(pStructure -> pStructure.maxDepth), (App)HeightProvider.CODEC.fieldOf("min_height").forGetter(pStructure -> pStructure.minHeight), (App)HeightProvider.CODEC.fieldOf("max_height").forGetter(pStructure -> pStructure.maxHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(pStructure -> pStructure.useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(pStructure -> pStructure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(pStructure -> pStructure.maxDistanceFromCenter), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(pStructure -> pStructure.poolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DimensionPadding.ZERO).forGetter(pStructure -> pStructure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.APPLY_WATERLOGGING).forGetter(pStructure -> pStructure.liquidSettings)).apply((Applicative)pInstance, IcariaJigsawStructure::new)).validate(IcariaJigsawStructure::verifyRange);
    public Optional<Heightmap.Types> projectStartToHeightmap;
    public Optional<ResourceLocation> startJigsawName;

    public IcariaJigsawStructure(Structure.StructureSettings pStructureSettings, Holder<StructureTemplatePool> pStartPool, Optional<ResourceLocation> pStartJigsaw, int pMaxDepth, HeightProvider pMinHeight, HeightProvider pMaxHeight, boolean pUseExpansionHack, Optional<Heightmap.Types> pProjectStartToHeightmap, int pMaxDistanceFromCenter, List<PoolAliasBinding> pPoolAliases, DimensionPadding pDimensionPadding, LiquidSettings pLiquidSettings) {
        super(pStructureSettings);
        this.startPool = pStartPool;
        this.startJigsawName = pStartJigsaw;
        this.maxDepth = pMaxDepth;
        this.minHeight = pMinHeight;
        this.maxHeight = pMaxHeight;
        this.useExpansionHack = pUseExpansionHack;
        this.projectStartToHeightmap = pProjectStartToHeightmap;
        this.maxDistanceFromCenter = pMaxDistanceFromCenter;
        this.poolAliases = pPoolAliases;
        this.dimensionPadding = pDimensionPadding;
        this.liquidSettings = pLiquidSettings;
    }

    public static DataResult<IcariaJigsawStructure> verifyRange(IcariaJigsawStructure pStructure) {
        int i = switch (pStructure.terrainAdaptation()) {
            default -> throw new MatchException(null, null);
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX, TerrainAdjustment.ENCAPSULATE -> 12;
        };
        return pStructure.maxDistanceFromCenter + i > 256 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 256") : DataResult.success((Object)((Object)pStructure));
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext pContext) {
        ChunkPos chunkPos = pContext.chunkPos();
        ChunkGenerator chunkGenerator = pContext.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = pContext.heightAccessor();
        WorldGenerationContext worldGenerationContext = new WorldGenerationContext(chunkGenerator, levelHeightAccessor);
        WorldgenRandom worldgenRandom = pContext.random();
        int x = chunkPos.getMinBlockX() + worldgenRandom.nextInt(16);
        int z = chunkPos.getMinBlockZ() + worldgenRandom.nextInt(16);
        NoiseColumn noiseColumn = chunkGenerator.getBaseColumn(x, z, levelHeightAccessor, pContext.randomState());
        int i = this.minHeight.sample((RandomSource)worldgenRandom, worldGenerationContext);
        int j = this.maxHeight.sample((RandomSource)worldgenRandom, worldGenerationContext);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, j, z);
        while (j > i) {
            BlockState blockState = noiseColumn.getBlock(j);
            BlockState belowState = noiseColumn.getBlock(--j);
            if (!blockState.isAir() || !belowState.isFaceSturdy((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mutableBlockPos.setY(j), Direction.UP)) continue;
            break;
        }
        if (j <= i) {
            return Optional.empty();
        }
        BlockPos blockPos = new BlockPos(x, j, z);
        PoolAliasLookup poolAliasLookup = PoolAliasLookup.create(this.poolAliases, (BlockPos)blockPos, (long)pContext.seed());
        return JigsawPlacement.addPieces((Structure.GenerationContext)pContext, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)poolAliasLookup, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }

    public StructureType<?> type() {
        return IcariaStructureTypes.JIGSAW.get();
    }
}

