/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.data.advancements;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaDimensions;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaSimpleAdvancements
implements AdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider pProvider, Consumer<AdvancementHolder> pConsumer, ExistingFileHelper pHelper) {
        Criterion rootTrigger = ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(IcariaDimensions.ICARIA);
        Criterion arachneTrigger = KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(IcariaEntityTypes.ARACHNE.get()));
        Criterion captainRevenantTrigger = KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(IcariaEntityTypes.CAPTAIN_REVENANT.get()));
        Criterion chestTrigger = ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{IcariaBlocks.CHEST.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)IcariaItems.CHEST_LABEL.get()}));
        Criterion barrelTrigger = EffectsChangedTrigger.TriggerInstance.gotEffectsFrom((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(IcariaEntityTypes.BARREL.get()));
        Criterion lootVaseTrigger = EffectsChangedTrigger.TriggerInstance.gotEffectsFrom((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(IcariaEntityTypes.LOOT_VASE.get()));
        Criterion storageVaseTrigger = ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.STORAGE_VASE.get());
        Criterion chertPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.CHERT_TOOLS.pickaxe.get()});
        Criterion chalkosPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.CHALKOS_TOOLS.pickaxe.get()});
        Criterion kilnTrigger = ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.KILN.get());
        Criterion kassiterosPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.KASSITEROS_TOOLS.pickaxe.get()});
        Criterion forgeTrigger = ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.FORGE.get());
        Criterion orichalcumPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.ORICHALCUM_TOOLS.pickaxe.get()});
        Criterion grinderTrigger = ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.GRINDER.get());
        Criterion fertilizedFarmlandTrigger = ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{IcariaBlocks.FERTILIZED_FARMLAND.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)IcariaItems.CALCITE_DUST.get()}));
        Criterion vanadiumsteelPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.VANADIUMSTEEL_TOOLS.pickaxe.get()});
        Criterion kettleTrigger = ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.KETTLE.get());
        Criterion siderosPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.SIDEROS_TOOLS.pickaxe.get()});
        Criterion molybdenumsteelPickaxeTrigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.MOLYBDENUMSTEEL_TOOLS.pickaxe.get()});
        AdvancementHolder root = IcariaSimpleAdvancements.advancement("root", rootTrigger, pConsumer, IcariaItems.GRASSY_MARL, AdvancementType.TASK, true, true, false);
        AdvancementHolder arachne = IcariaSimpleAdvancements.advancement("arachne", arachneTrigger, root, pConsumer, IcariaItems.ARACHNE_STRING, AdvancementType.TASK, true, true, false);
        AdvancementHolder captainRevenant = IcariaSimpleAdvancements.advancement("captain_revenant", captainRevenantTrigger, root, pConsumer, IcariaItems.REVENANT_SKULL, AdvancementType.TASK, true, true, false);
        AdvancementHolder chest = IcariaSimpleAdvancements.icariaChest("chest", chestTrigger, root, pConsumer, IcariaItems.CHEST, AdvancementType.TASK, true, true, false);
        AdvancementHolder barrel = IcariaSimpleAdvancements.advancement("barrel", barrelTrigger, root, pConsumer, IcariaItems.LAUREL_BARREL, AdvancementType.TASK, true, true, false);
        AdvancementHolder lootVase = IcariaSimpleAdvancements.advancement("loot_vase", lootVaseTrigger, root, pConsumer, IcariaItems.CYAN_LOOT_VASE, AdvancementType.TASK, true, true, false);
        AdvancementHolder storageVase = IcariaSimpleAdvancements.storageVase("storage_vase", storageVaseTrigger, root, pConsumer, IcariaItems.STORAGE_VASE, AdvancementType.TASK, true, true, false);
        AdvancementHolder chertPickaxe = IcariaSimpleAdvancements.advancement("chert_pickaxe", chertPickaxeTrigger, root, pConsumer, IcariaItems.CHERT_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
        AdvancementHolder chalkosPickaxe = IcariaSimpleAdvancements.advancement("chalkos_pickaxe", chalkosPickaxeTrigger, chertPickaxe, pConsumer, IcariaItems.CHALKOS_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
        AdvancementHolder kiln = IcariaSimpleAdvancements.advancement("kiln", kilnTrigger, chertPickaxe, pConsumer, IcariaItems.KILN, AdvancementType.TASK, true, true, false);
        AdvancementHolder kassiterosPickaxe = IcariaSimpleAdvancements.advancement("kassiteros_pickaxe", kassiterosPickaxeTrigger, chalkosPickaxe, pConsumer, IcariaItems.KASSITEROS_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
        AdvancementHolder forge = IcariaSimpleAdvancements.advancement("forge", forgeTrigger, chalkosPickaxe, pConsumer, IcariaItems.FORGE, AdvancementType.TASK, true, true, false);
        AdvancementHolder orichalcumPickaxe = IcariaSimpleAdvancements.advancement("orichalcum_pickaxe", orichalcumPickaxeTrigger, kassiterosPickaxe, pConsumer, IcariaItems.ORICHALCUM_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
        AdvancementHolder grinder = IcariaSimpleAdvancements.advancement("grinder", grinderTrigger, kassiterosPickaxe, pConsumer, IcariaItems.GRINDER, AdvancementType.TASK, true, true, false);
        AdvancementHolder fertilizedFarmland = IcariaSimpleAdvancements.advancement("fertilized_farmland", fertilizedFarmlandTrigger, grinder, pConsumer, IcariaItems.CALCITE_DUST, AdvancementType.TASK, true, true, false);
        AdvancementHolder vanadiumsteelPickaxe = IcariaSimpleAdvancements.advancement("vanadiumsteel_pickaxe", vanadiumsteelPickaxeTrigger, orichalcumPickaxe, pConsumer, IcariaItems.VANADIUMSTEEL_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
        AdvancementHolder kettle = IcariaSimpleAdvancements.advancement("kettle", kettleTrigger, orichalcumPickaxe, pConsumer, IcariaItems.KETTLE, AdvancementType.TASK, true, true, false);
        AdvancementHolder siderosPickaxe = IcariaSimpleAdvancements.advancement("sideros_pickaxe", siderosPickaxeTrigger, vanadiumsteelPickaxe, pConsumer, IcariaItems.SIDEROS_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
        AdvancementHolder molybdenumsteelPickaxe = IcariaSimpleAdvancements.advancement("molybdenumsteel_pickaxe", molybdenumsteelPickaxeTrigger, siderosPickaxe, pConsumer, IcariaItems.MOLYBDENUMSTEEL_TOOLS.pickaxe, AdvancementType.TASK, true, true, false);
    }

    public static AdvancementHolder advancement(String pKey, Criterion<?> pTrigger, Consumer<AdvancementHolder> pConsumer, Supplier<Item> pItem, AdvancementType pFrame, boolean pToast, boolean pChat, boolean pHidden) {
        return Advancement.Builder.advancement().addCriterion(pKey, pTrigger).display((ItemLike)pItem.get(), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".title")), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".description")), IcariaResourceLocations.BACKGROUND, pFrame, pToast, pChat, pHidden).save(pConsumer, "landsoficaria:" + pKey);
    }

    public static AdvancementHolder advancement(String pKey, Criterion<?> pTrigger, AdvancementHolder pParent, Consumer<AdvancementHolder> pConsumer, Supplier<Item> pItem, AdvancementType pFrame, boolean pToast, boolean pChat, boolean pHidden) {
        return Advancement.Builder.advancement().addCriterion(pKey, pTrigger).display((ItemLike)pItem.get(), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".title")), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".description")), IcariaResourceLocations.BACKGROUND, pFrame, pToast, pChat, pHidden).parent(pParent).save(pConsumer, "landsoficaria:" + pKey);
    }

    public static AdvancementHolder icariaChest(String pKey, Criterion<?> pTrigger, AdvancementHolder pParent, Consumer<AdvancementHolder> pConsumer, Supplier<Item> pItem, AdvancementType pFrame, boolean pToast, boolean pChat, boolean pHidden) {
        return Advancement.Builder.advancement().addCriterion(pKey, pTrigger).addCriterion("trapped_chest", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{IcariaBlocks.TRAPPED_CHEST.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)IcariaItems.CHEST_LABEL.get()}))).display((ItemLike)pItem.get(), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".title")), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".description")), IcariaResourceLocations.BACKGROUND, pFrame, pToast, pChat, pHidden).parent(pParent).requirements(AdvancementRequirements.Strategy.OR).save(pConsumer, "landsoficaria:" + pKey);
    }

    public static AdvancementHolder storageVase(String pKey, Criterion<?> pTrigger, AdvancementHolder pParent, Consumer<AdvancementHolder> pConsumer, Supplier<Item> pItem, AdvancementType pFrame, boolean pToast, boolean pChat, boolean pHidden) {
        return Advancement.Builder.advancement().addCriterion(pKey, pTrigger).addCriterion("white_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.WHITE_STORAGE_VASE.get())).addCriterion("light_gray_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.LIGHT_GRAY_STORAGE_VASE.get())).addCriterion("gray_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.GRAY_STORAGE_VASE.get())).addCriterion("black_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.BLACK_STORAGE_VASE.get())).addCriterion("brown_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.BROWN_STORAGE_VASE.get())).addCriterion("red_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.RED_STORAGE_VASE.get())).addCriterion("orange_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.ORANGE_STORAGE_VASE.get())).addCriterion("yellow_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.YELLOW_STORAGE_VASE.get())).addCriterion("lime_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.LIME_STORAGE_VASE.get())).addCriterion("green_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.GREEN_STORAGE_VASE.get())).addCriterion("cyan_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.CYAN_STORAGE_VASE.get())).addCriterion("light_blue_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.LIGHT_BLUE_STORAGE_VASE.get())).addCriterion("blue_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.BLUE_STORAGE_VASE.get())).addCriterion("purple_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.PURPLE_STORAGE_VASE.get())).addCriterion("magenta_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.MAGENTA_STORAGE_VASE.get())).addCriterion("pink_storage_vase", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)IcariaBlocks.PINK_STORAGE_VASE.get())).display((ItemLike)pItem.get(), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".title")), (Component)Component.translatable((String)("advancement.landsoficaria." + pKey + ".description")), IcariaResourceLocations.BACKGROUND, pFrame, pToast, pChat, pHidden).parent(pParent).requirements(AdvancementRequirements.Strategy.OR).save(pConsumer, "landsoficaria:" + pKey);
    }
}

