/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.data.loot;

import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaEntityLoot
extends EntityLootSubProvider {
    public IcariaEntityLoot(HolderLookup.Provider pProvider) {
        super(FeatureFlags.REGISTRY.allFlags(), pProvider);
    }

    public void generate() {
        this.arachneQueen();
        this.capella();
        this.laurelForest();
        this.dropNone(IcariaEntityTypes.HYLIASTER.get());
        this.dropNone(IcariaEntityTypes.MYRMEKE_DRONE.get());
        this.dropNone(IcariaEntityTypes.MYRMEKE_QUEEN.get());
        this.dropNone(IcariaEntityTypes.SCORPION.get());
        this.dropNone(IcariaEntityTypes.SOLIFUGAE.get());
        this.dropNone(IcariaEntityTypes.VINEGAROON.get());
        this.dropNone(IcariaEntityTypes.ARGAN_HOUND.get(), IcariaItems.ARGAN_HOUND_SKULL.get());
        this.dropItem(IcariaEntityTypes.ARACHNE_DRONE.get(), IcariaItems.ARACHNE_STRING.get());
        this.dropItem(IcariaEntityTypes.FIRE_JELLYFISH.get(), IcariaItems.FIRE_JELLYFISH_JELLY.get());
        this.dropItem(IcariaEntityTypes.NATURE_JELLYFISH.get(), IcariaItems.NATURE_JELLYFISH_JELLY.get());
        this.dropItem(IcariaEntityTypes.VOID_JELLYFISH.get(), IcariaItems.VOID_JELLYFISH_JELLY.get());
        this.dropItem(IcariaEntityTypes.WATER_JELLYFISH.get(), IcariaItems.WATER_JELLYFISH_JELLY.get());
        this.dropItem(IcariaEntityTypes.MYRMEKE_SOLDIER.get(), IcariaItems.MYRMEKE_SCALES.get());
        this.dropItem(IcariaEntityTypes.CAPTAIN_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE);
        this.dropItem(IcariaEntityTypes.CIVILIAN_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE);
        this.dropItem(IcariaEntityTypes.CRAWLER_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE);
        this.dropItem(IcariaEntityTypes.SOLDIER_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE);
        this.dropItem(IcariaEntityTypes.SNULL.get(), IcariaItems.REVENANT_SKULL.get(), IcariaItems.SNULL_CREAM.get());
        this.dropItemWithCookFunc(IcariaEntityTypes.CATOBLEPAS.get(), IcariaItems.CATOBLEPAS_SKULL.get(), IcariaItems.RAW_CATOBLEPAS_MEAT.get());
        this.dropItemWithCookFunc(IcariaEntityTypes.CERVER.get(), IcariaItems.CERVER_SKULL.get(), IcariaItems.RAW_CERVER_MEAT.get());
        this.dropItemWithCookFunc(IcariaEntityTypes.CROCOTTA.get(), IcariaItems.CROCOTTA_SKULL.get(), IcariaItems.RAW_CROCOTTA_MEAT.get());
        this.dropItemWithCookFunc(IcariaEntityTypes.SOW.get(), IcariaItems.SOW_SKULL.get(), IcariaItems.RAW_SOW_MEAT.get());
        this.dropItemPlusScnd(IcariaEntityTypes.ENDER_JELLYFISH.get(), IcariaItems.ENDER_JELLYFISH_JELLY.get(), Items.ENDER_PEARL);
        this.dropItemPlusScnd(IcariaEntityTypes.OVERGROWN_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE, IcariaItems.CALCITE_SHARD.get());
        this.dropItemPlusScnd(IcariaEntityTypes.FOREST_SNULL.get(), IcariaItems.LAUREL_FOREST_HAG_SKULL.get(), IcariaItems.SNULL_CREAM.get(), IcariaItems.MOTH_AGARIC.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.AETERNAE.get(), IcariaItems.AETERNAE_SKULL.get(), IcariaItems.AETERNAE_HIDE.get(), IcariaItems.RAW_AETERNAE_MEAT.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.CYPRESS_FOREST_HAG.get(), IcariaItems.CYPRESS_FOREST_HAG_SKULL.get(), IcariaItems.CYPRESS_SAPLING.get(), IcariaItems.CYPRESS_LOG.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.DROUGHTROOT_FOREST_HAG.get(), IcariaItems.DROUGHTROOT_FOREST_HAG_SKULL.get(), IcariaItems.DROUGHTROOT_SAPLING.get(), IcariaItems.DROUGHTROOT_LOG.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.FIR_FOREST_HAG.get(), IcariaItems.FIR_FOREST_HAG_SKULL.get(), IcariaItems.FIR_SAPLING.get(), IcariaItems.FIR_LOG.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.OLIVE_FOREST_HAG.get(), IcariaItems.OLIVE_FOREST_HAG_SKULL.get(), IcariaItems.OLIVE_SAPLING.get(), IcariaItems.OLIVE_LOG.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.PLANE_FOREST_HAG.get(), IcariaItems.PLANE_FOREST_HAG_SKULL.get(), IcariaItems.PLANE_SAPLING.get(), IcariaItems.PLANE_LOG.get());
        this.dropItemPlusScndWithCookFunc(IcariaEntityTypes.POPULUS_FOREST_HAG.get(), IcariaItems.POPULUS_FOREST_HAG_SKULL.get(), IcariaItems.POPULUS_SAPLING.get(), IcariaItems.POPULUS_LOG.get());
        this.dropItemPlusScndPlusThrd(IcariaEntityTypes.CRYSTAL_SLUG.get(), IcariaItems.SNULL_CREAM.get(), IcariaItems.SLUG_SCALES.get(), IcariaItems.JASPER_SHARD.get());
        this.dropItemPlusScndPlusThrd(IcariaEntityTypes.PYROMANCER_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE, IcariaItems.GREENPOWDER.get(), IcariaItems.GREEK_FIRE_GRENADE.get());
        this.dropItemPlusScndPlusThrd(IcariaEntityTypes.NETHER_PYROMANCER_REVENANT.get(), IcariaItems.REVENANT_SKULL.get(), Items.BONE, IcariaItems.GREENPOWDER.get(), IcariaItems.GREEK_FIRE_GRENADE.get());
    }

    public void arachneQueen() {
        this.add(IcariaEntityTypes.ARACHNE.get(), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.ARACHNE_STRING.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.TOTEM_OF_STUFFING.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.TOTEM_OF_UNBLINDING.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.TOTEM_OF_UNDROWNING.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.TOTEM_OF_UNSHATTERING.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.TOTEM_OF_UNSINKING.get())))));
    }

    public void capella() {
        this.add(IcariaEntityTypes.CAPELLA.get(), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.CAPELLA_SKULL.get()))).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.CAPELLA_HORN.get())).when(LootItemRandomChanceCondition.randomChance((float)0.1f)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.RAW_CAPELLA_MEAT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void laurelForest() {
        this.add(IcariaEntityTypes.LAUREL_FOREST_HAG.get(), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.LAUREL_FOREST_HAG_SKULL.get()))).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.LAUREL_SAPLING.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.LAUREL_WREATH.get())).when(LootItemRandomChanceCondition.randomChance((float)0.1f)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)IcariaItems.LAUREL_LOG.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void dropNone(EntityType<?> pEntity) {
        this.add(pEntity, LootTable.lootTable());
    }

    public void dropNone(EntityType<?> pEntity, Item pSkull) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))));
    }

    public void dropItem(EntityType<?> pEntity, Item pItem) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
    }

    public void dropItem(EntityType<?> pEntity, Item pSkull, Item pItem) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
    }

    public void dropItemWithCookFunc(EntityType<?> pEntity, Item pItem) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void dropItemWithCookFunc(EntityType<?> pEntity, Item pSkull, Item pItem) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void dropItemPlusScnd(EntityType<?> pEntity, Item pItem, Item pScnd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
    }

    public void dropItemPlusScnd(EntityType<?> pEntity, Item pSkull, Item pItem, Item pScnd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
    }

    public void dropItemPlusScndWithCookFunc(EntityType<?> pEntity, Item pItem, Item pScnd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void dropItemPlusScndWithCookFunc(EntityType<?> pEntity, Item pSkull, Item pItem, Item pScnd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void dropItemPlusScndPlusThrd(EntityType<?> pEntity, Item pItem, Item pScnd, Item pThrd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pThrd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
    }

    public void dropItemPlusScndPlusThrd(EntityType<?> pEntity, Item pSkull, Item pItem, Item pScnd, Item pThrd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pThrd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
    }

    public void dropItemPlusScndPlusThrdWithCookFunc(EntityType<?> pEntity, Item pItem, Item pScnd, Item pThrd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pThrd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public void dropItemPlusScndPlusThrdWithCookFunc(EntityType<?> pEntity, Item pSkull, Item pItem, Item pScnd, Item pThrd) {
        this.add(pEntity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSkull)).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pScnd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pThrd).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))));
    }

    public Stream<EntityType<?>> getKnownEntityTypes() {
        return BuiltInRegistries.ENTITY_TYPE.stream().filter(pEntityType -> BuiltInRegistries.ENTITY_TYPE.getKey(pEntityType).getNamespace().equals("landsoficaria"));
    }
}

