/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.integration.jei.category;

import com.axanthic.icaria.common.recipe.FiringRecipe;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FiringRecipeCategory
implements IRecipeCategory<FiringRecipe> {
    public IDrawable background;
    public IDrawable icon;
    public IDrawableStatic staticArrow;
    public IDrawableAnimated animatedArrow;
    public IDrawableStatic staticFlame;
    public IDrawableAnimated animatedFlame;

    public FiringRecipeCategory(IGuiHelper pHelper) {
        this.background = pHelper.createDrawable(IcariaResourceLocations.KILN_CATEGORY, 0, 0, 154, 54);
        this.icon = pHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)IcariaItems.KILN.get()));
        this.staticArrow = pHelper.createDrawable(IcariaResourceLocations.KILN_CATEGORY, 154, 0, 22, 16);
        this.animatedArrow = pHelper.createAnimatedDrawable(this.staticArrow, 300, IDrawableAnimated.StartDirection.LEFT, false);
        this.staticFlame = pHelper.createDrawable(IcariaResourceLocations.KILN_CATEGORY, 154, 16, 9, 14);
        this.animatedFlame = pHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void draw(FiringRecipe pRecipe, IRecipeSlotsView pView, GuiGraphics pGraphics, double pMouseX, double pMouseY) {
        this.animatedArrow.draw(pGraphics, 62, 19);
        this.animatedFlame.draw(pGraphics, 37, 20);
        this.drawBurnTime(pRecipe, pGraphics, 19, 46);
        this.drawExperience(pRecipe, pGraphics, 19, 1);
    }

    public void drawBurnTime(FiringRecipe pRecipe, GuiGraphics pGraphics, int pX, int pY) {
        int burnTime = pRecipe.getBurnTime();
        if (burnTime > 0) {
            Font font = Minecraft.getInstance().font;
            MutableComponent burnTimeText = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{burnTime / 20});
            pGraphics.drawString(font, (Component)burnTimeText, this.getWidth() - font.width((FormattedText)burnTimeText) - pX, pY, -8355712, false);
        }
    }

    public void drawExperience(FiringRecipe pRecipe, GuiGraphics pGraphics, int pX, int pY) {
        float experience = pRecipe.getExperience();
        if (experience > 0.0f) {
            Font font = Minecraft.getInstance().font;
            MutableComponent experienceText = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            pGraphics.drawString(font, (Component)experienceText, this.getWidth() - font.width((FormattedText)experienceText) - pX, pY, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder pBuilder, FiringRecipe pRecipe, IFocusGroup pGroup) {
        pBuilder.addSlot(RecipeIngredientRole.INPUT, 34, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(0));
        pBuilder.addSlot(RecipeIngredientRole.OUTPUT, 100, 19).addItemStack(pRecipe.getResultItem(null));
    }

    public Component getTitle() {
        return Component.translatable((String)"category.landsoficaria.firing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<FiringRecipe> getRecipeType() {
        return RecipeType.create((String)"landsoficaria", (String)"firing", FiringRecipe.class);
    }
}

