/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.integration.jei.category;

import com.axanthic.icaria.common.recipe.ForgingRecipe;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForgingRecipeCategory
implements IRecipeCategory<ForgingRecipe> {
    public IDrawable background;
    public IDrawable icon;
    public IDrawableStatic staticArrow;
    public IDrawableAnimated animatedArrow;
    public IDrawableStatic staticFlame;
    public IDrawableAnimated animatedFlame;

    public ForgingRecipeCategory(IGuiHelper pHelper) {
        this.background = pHelper.createDrawable(IcariaResourceLocations.FORGE_CATEGORY, 0, 0, 154, 54);
        this.icon = pHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)IcariaItems.FORGE.get()));
        this.staticArrow = pHelper.createDrawable(IcariaResourceLocations.FORGE_CATEGORY, 154, 0, 22, 16);
        this.animatedArrow = pHelper.createAnimatedDrawable(this.staticArrow, 300, IDrawableAnimated.StartDirection.LEFT, false);
        this.staticFlame = pHelper.createDrawable(IcariaResourceLocations.FORGE_CATEGORY, 154, 16, 16, 14);
        this.animatedFlame = pHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void draw(ForgingRecipe pRecipe, IRecipeSlotsView pView, GuiGraphics pGraphics, double pMouseX, double pMouseY) {
        this.animatedArrow.draw(pGraphics, 71, 19);
        this.animatedFlame.draw(pGraphics, 42, 20);
        this.drawBurnTime(pRecipe, pGraphics, 52, 1);
        this.drawExperience(pRecipe, pGraphics, 52, 46);
    }

    public void drawBurnTime(ForgingRecipe pRecipe, GuiGraphics pGraphics, int pX, int pY) {
        int burnTime = pRecipe.getBurnTime();
        if (burnTime > 0) {
            Font font = Minecraft.getInstance().font;
            MutableComponent burnTimeText = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{burnTime / 20});
            pGraphics.drawString(font, (Component)burnTimeText, this.getWidth() - font.width((FormattedText)burnTimeText) - pX, pY, -8355712, false);
        }
    }

    public void drawExperience(ForgingRecipe pRecipe, GuiGraphics pGraphics, int pX, int pY) {
        float experience = pRecipe.getExperience();
        if (experience > 0.0f) {
            Font font = Minecraft.getInstance().font;
            MutableComponent experienceText = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            pGraphics.drawString(font, (Component)experienceText, this.getWidth() - font.width((FormattedText)experienceText) - pX, pY, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder pBuilder, ForgingRecipe pRecipe, IFocusGroup pGroup) {
        if (pRecipe.getIngredients().size() == 3) {
            pBuilder.addSlot(RecipeIngredientRole.INPUT, 25, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(0));
            pBuilder.addSlot(RecipeIngredientRole.INPUT, 43, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(1));
            pBuilder.addSlot(RecipeIngredientRole.INPUT, 61, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(2));
            pBuilder.addSlot(RecipeIngredientRole.OUTPUT, 109, 5).addItemStack(pRecipe.getResultItem(null));
        } else if (pRecipe.getIngredients().size() == 2) {
            pBuilder.addSlot(RecipeIngredientRole.INPUT, 25, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(0));
            pBuilder.addSlot(RecipeIngredientRole.INPUT, 43, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(1));
            pBuilder.addSlot(RecipeIngredientRole.OUTPUT, 109, 5).addItemStack(pRecipe.getResultItem(null));
        } else if (pRecipe.getIngredients().size() == 1) {
            pBuilder.addSlot(RecipeIngredientRole.INPUT, 25, 1).addIngredients((Ingredient)pRecipe.getIngredients().get(0));
            pBuilder.addSlot(RecipeIngredientRole.OUTPUT, 109, 5).addItemStack(pRecipe.getResultItem(null));
        }
    }

    public Component getTitle() {
        return Component.translatable((String)"category.landsoficaria.forging");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<ForgingRecipe> getRecipeType() {
        return RecipeType.create((String)"landsoficaria", (String)"forging", ForgingRecipe.class);
    }
}

