/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.mixin;

import com.axanthic.icaria.client.renderer.IcariaSkullBlockRenderer;
import com.axanthic.icaria.common.item.IcariaSkullItem;
import com.axanthic.icaria.common.util.IcariaSkullBlockType;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={CustomHeadLayer.class})
public class CustomHeadLayerMixin<T extends LivingEntity, M extends EntityModel<T>> {
    private EntityModelSet set;
    private Map<IcariaSkullBlockType, SkullModel> map;

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/renderer/entity/RenderLayerParent;Lnet/minecraft/client/model/geom/EntityModelSet;FFFLnet/minecraft/client/renderer/ItemInHandRenderer;)V"})
    private void initMixin(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet, float pScaleX, float pScaleY, float pScaleZ, ItemInHandRenderer pItemInHandRenderer, CallbackInfo pCallbackInfo) {
        this.set = pModelSet;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/CustomHeadLayer;translateToHead(Lcom/mojang/blaze3d/vertex/PoseStack;Z)V", shift=At.Shift.BEFORE)}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, cancellable=true)
    private void renderHeadMixin(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, @Nonnull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch, CallbackInfo pCallbackInfo) {
        Item item;
        if (this.map == null) {
            this.map = IcariaSkullBlockRenderer.createRenderers(this.set);
        }
        if ((item = pLivingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof IcariaSkullItem) {
            IcariaSkullItem skullItem = (IcariaSkullItem)item;
            pMatrixStack.scale(1.1875f, -1.1875f, -1.1875f);
            pMatrixStack.translate(-0.5, 0.0, -0.5);
            IcariaSkullBlockRenderer.renderSkull(null, 180.0f, pMatrixStack, pBuffer, pPackedLight, this.map, skullItem.getBlock());
            pMatrixStack.popPose();
            pCallbackInfo.cancel();
        }
    }
}

