/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SparkEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(SparkEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> RELIC_STACK = SynchedEntityData.defineId(SparkEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private LivingEntity target;

    public SparkEntity(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        super.tick();
        Level level = this.getCommandSenderWorld();
        Vec3 particleCenter = this.getPosition(1.0f).add(0.0, 0.5, 0.0);
        level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(200 + this.random.nextInt(56), 100 + this.random.nextInt(156), 0), (float)(0.01f + this.random.nextFloat() * 0.1f), (int)(5 + this.random.nextInt(3)), (float)0.9f), particleCenter.x() + (double)(MathUtils.randomFloat((RandomSource)this.random) * 0.05f), particleCenter.y() + (double)(MathUtils.randomFloat((RandomSource)this.random) * 0.05f), particleCenter.z() + (double)(MathUtils.randomFloat((RandomSource)this.random) * 0.05f), 0.0, 0.0, 0.0);
        if (level.isClientSide()) {
            return;
        }
        if (this.target == null || this.target.isDeadOrDying() || this.tickCount >= 120) {
            this.discard();
            return;
        }
        if (this.distanceTo((Entity)this.target) <= 1.0f) {
            this.hitEntity(this.target);
        }
        Vec3 targetPos = new Vec3(this.target.getX(), this.target.getY() + (double)(this.target.getBbHeight() / 2.0f), this.target.getZ());
        Vec3 direction = targetPos.subtract(this.position()).normalize();
        Vec3 motion = this.getDeltaMovement();
        float factor = Math.clamp((float)this.tickCount * 0.05f, 0.0f, 1.0f);
        double deltaX = motion.x + (direction.x * (double)factor - motion.x) * (double)factor;
        double deltaZ = motion.z + (direction.z * (double)factor - motion.z) * (double)factor;
        this.setDeltaMovement(new Vec3(deltaX, direction.scale((double)(this.position().distanceTo((Vec3)targetPos) * (double)((float)this.tickCount * 0.01f))).y, deltaZ));
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        EntityHitResult entityResult;
        Entity entity;
        super.onHitEntity(result);
        if (result instanceof EntityHitResult && (entity = (entityResult = result).getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.hitEntity(entity2);
        }
    }

    public void hitEntity(LivingEntity target) {
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!target.getStringUUID().equals(player.getStringUUID())) {
                Item item;
                target.invulnerableTime = 0;
                if (target.hurt(this.getCommandSenderWorld().damageSources().onFire(), this.getDamage()) && (item = this.getRelicStack().getItem()) instanceof IRelicItem) {
                    IRelicItem relic = (IRelicItem)item;
                    target.setRemainingFireTicks((int)relic.getStatValue(this.getRelicStack(), "caster", "duration"));
                    relic.spreadRelicExperience((LivingEntity)player, this.getRelicStack(), 1);
                }
            }
        }
        this.discard();
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public boolean hurt(DamageSource p_19946_, float p_19947_) {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    public void setRelicStack(ItemStack stack) {
        this.getEntityData().set(RELIC_STACK, (Object)stack);
    }

    public ItemStack getRelicStack() {
        return (ItemStack)this.getEntityData().get(RELIC_STACK);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("relic_stack", this.getRelicStack().save((HolderLookup.Provider)this.registryAccess()));
        tag.putFloat("damage", this.getDamage());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setRelicStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("relic_stack")));
        this.setDamage(tag.getFloat("damage"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
        builder.define(RELIC_STACK, (Object)ItemStack.EMPTY);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<SparkEntity> {
        public TrailProvider(SparkEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((SparkEntity)this.entity).getPosition(partialTicks).add(0.0, 0.5, 0.0);
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((SparkEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((SparkEntity)this.entity).tickCount > 2;
        }

        public int getTrailMaxLength() {
            return 4;
        }

        public int getTrailFadeInColor() {
            return -5103070;
        }

        public int getTrailFadeOutColor() {
            return -2130736128;
        }

        public double getTrailScale() {
            return 0.05f;
        }
    }
}

