/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModTags;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;

public record DamageImmunity(Value<Boolean> enabled, TagKey<DamageType> tag, EntityCondition condition) implements EquipmentAbility
{
    private static final Set<TagKey<DamageType>> CUSTOM_TOOLTIP_TAGS = Set.of(DamageTypeTags.IS_LIGHTNING, ModTags.IS_HOT_FLOOR);
    public static final Codec<DamageImmunity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.enabledField().forGetter(DamageImmunity::enabled), (App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("tag").forGetter(DamageImmunity::tag), (App)EntityCondition.CODEC.optionalFieldOf("condition", (Object)EntityCondition.ALWAYS).forGetter(DamageImmunity::condition)).apply((Applicative)instance, DamageImmunity::new));
    public static final StreamCodec<ByteBuf, DamageImmunity> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), DamageImmunity::enabled, ModCodecs.tagKeyStreamCodec(Registries.DAMAGE_TYPE), DamageImmunity::tag, EntityCondition.STREAM_CODEC, DamageImmunity::condition, DamageImmunity::new);

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        if (CUSTOM_TOOLTIP_TAGS.contains(this.tag()) && this.condition() == EntityCondition.ALWAYS) {
            writer.add(this.tag().location().getPath(), new Object[0]);
        }
    }
}

