/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.ability.nightvision.client;

import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @ModifyReturnValue(method={"getNightVisionScale(Lnet/minecraft/world/entity/LivingEntity;F)F"}, at={@At(value="RETURN")})
    private static float getNightVisionScale(float original, LivingEntity entity, float f) {
        MobEffectInstance effect = entity.getEffect(MobEffects.NIGHT_VISION);
        if (effect == null || !effect.endsWithin(240)) {
            return original;
        }
        double scale = EquipmentHelper.reduceComponents(ModDataComponents.REDUCED_NIGHT_VISION.get(), entity, 0.0, (prefix, stack, component) -> Math.max((Double)component.get(), prefix));
        if (scale == 0.0) {
            return original;
        }
        return Mth.lerp((float)(Math.max(0.0f, (float)effect.getDuration() - f - 220.0f) / 20.0f), (float)((float)scale), (float)original);
    }
}

