/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.entry.PedestalRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ImbuementRecipeEntry
extends PedestalRecipeEntry {
    RecipeHolder<ImbuementRecipe> recipe;

    public ImbuementRecipeEntry(RecipeHolder<ImbuementRecipe> recipe, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.recipe = recipe;
        this.image = DocAssets.IMBUEMENT_RECIPE;
        this.title = Component.translatable((String)"block.ars_nouveau.imbuement_chamber");
        if (recipe != null && recipe.value() != null) {
            this.outputStack = ((ImbuementRecipe)recipe.value()).output;
            this.ingredients = ((ImbuementRecipe)recipe.value()).getPedestalItems();
            this.reagentStack = ((ImbuementRecipe)recipe.value()).input;
        }
    }

    public static SinglePageCtor create(RecipeHolder<ImbuementRecipe> recipe) {
        return (parent, x, y, width, height) -> new ImbuementRecipeEntry(recipe, parent, x, y, width, height);
    }

    @Override
    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        if (this.recipe != null) {
            object.addProperty(DocExporter.RECIPE_PROPERTY, this.recipe.id().toString());
        }
    }
}

