/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SpeedProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.hollingsworth.arsnouveau.api.util.NoiseGenerator;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class WispMotion
extends ParticleMotion {
    public static MapCodec<WispMotion> CODEC = WispMotion.buildPropCodec(WispMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, WispMotion> STREAM = WispMotion.buildStreamCodec(WispMotion::new);
    NoiseGenerator noise;

    public WispMotion() {
        this(new PropMap());
    }

    public WispMotion(PropMap propertyMap) {
        super(propertyMap);
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.WISP_TYPE.get();
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        if (this.noise == null) {
            this.noise = new NoiseGenerator();
        }
        ParticleDensityProperty density = this.getDensity(particleOptions, 20, 0.1f);
        int numParticles = this.getNumParticles(density.density());
        double flicker = 0.65;
        double randomScale = density.radius() * 0.03;
        double yDrift = 1.0;
        double xzDrift = 0.1f;
        for (int i = 0; i < numParticles; ++i) {
            double t = (double)i / (double)numParticles;
            double interpX = prevX + x * t;
            double interpY = prevY + y * t;
            double interpZ = prevZ + z * t;
            double flameBaseT = ((double)this.emitter.age + t) * xzDrift;
            double flickerX = this.noise.noise(flameBaseT, 100.0, 0.0) * flicker;
            double flickerZ = this.noise.noise(flameBaseT + 50.0, 200.0, 0.0) * flicker;
            double localY = this.noise.noise(flameBaseT + 100.0, 300.0, 0.0) * yDrift;
            Vec3 local = new Vec3(flickerX, localY * 0.5, flickerZ);
            Vec3 speed = this.randomSpeed(particleOptions);
            Vector3f pos = this.toEmitterSpace((float)interpX, (float)interpY, (float)interpZ, (float)local.x, (float)local.y, (float)local.z);
            level.addParticle((ParticleOptions)particleOptions, (double)pos.x, (double)pos.y, (double)pos.z, speed.x, speed.y, speed.z);
        }
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(20, 0.1, ParticleMotion.SpawnType.SPHERE).minDensity(1).maxDensity(200).densityStepSize(1)), propMap.createIfMissing(new SpeedProperty().yRange(0.01, 0.02)));
    }
}

