/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.perk;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="ars_nouveau", bus=EventBusSubscriber.Bus.MOD)
public class PerkAttributes {
    public static final HashMap<DeferredHolder<Attribute, Attribute>, UUID> UUIDS = new HashMap();
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"ars_nouveau");
    public static final DeferredHolder<Attribute, Attribute> WARDING = PerkAttributes.registerAttribute("ars_nouveau.perk.warding", (String id) -> new RangedAttribute(id, 0.0, 0.0, 1024.0).setSyncable(true), "07625fbb-f186-46c3-8b5f-989b747f29f8");
    public static final DeferredHolder<Attribute, Attribute> MANA_REGEN_BONUS = PerkAttributes.registerAttribute("ars_nouveau.perk.mana_regen", (String id) -> new RangedAttribute(id, 0.0, 0.0, 2000.0).setSyncable(true), "0c877091-ee4f-4eda-9868-4194d9a18833");
    public static final DeferredHolder<Attribute, Attribute> MAX_MANA = PerkAttributes.registerAttribute("ars_nouveau.perk.max_mana", (String id) -> new RangedAttribute(id, 0.0, 0.0, 10000.0).setSyncable(true), "22980b24-83e5-4683-a215-8997c4011389");
    public static final DeferredHolder<Attribute, Attribute> SPELL_DAMAGE_BONUS = PerkAttributes.registerAttribute("ars_nouveau.perk.spell_damage", (String id) -> new RangedAttribute(id, 0.0, 0.0, 10000.0).setSyncable(true), "50b50137-9c92-4e64-b350-6044e9e609de");
    public static final DeferredHolder<Attribute, Attribute> WHIRLIESPRIG = PerkAttributes.registerAttribute("ars_nouveau.perk.saturation", (String id) -> new RangedAttribute(id, 1.0, 0.0, 10000.0).setSyncable(true), "152810f7-0d01-484e-a512-73fe70af3db7");
    public static final DeferredHolder<Attribute, Attribute> WIXIE = PerkAttributes.registerAttribute("ars_nouveau.perk.wixie", (String id) -> new RangedAttribute(id, 1.0, 0.0, 1024.0).setSyncable(true), "bae5d566-c9f6-4abf-9fe0-6ac140a34db1");
    public static final DeferredHolder<Attribute, Attribute> DRYGMY = PerkAttributes.registerAttribute("ars_nouveau.perk.drygmy", (String id) -> new RangedAttribute(id, 0.0, 0.0, 1024.0).setSyncable(true), "bae5d566-9fe0-c9f6-4abf-6ac140a34db1");
    public static final DeferredHolder<Attribute, Attribute> FEATHER = PerkAttributes.registerAttribute("ars_nouveau.perk.feather", (String id) -> new RangedAttribute(id, 0.0, 0.0, 1.0).setSyncable(true), "ee3a4090-c5f5-4a26-a9c2-69837237b35f");
    public static final DeferredHolder<Attribute, Attribute> WEIGHT = PerkAttributes.registerAttribute("ars_nouveau.perk.weight", (String id) -> new RangedAttribute(id, 1.0, 0.0, 100.0).setSyncable(true), "24d1ae35-a7c7-4c85-9b56-c94de36faf91");

    public static DeferredHolder<Attribute, Attribute> registerAttribute(String name, Function<String, Attribute> attribute, String uuid) {
        return PerkAttributes.registerAttribute(name, attribute, UUID.fromString(uuid));
    }

    public static DeferredHolder<Attribute, Attribute> registerAttribute(String name, Function<String, Attribute> attribute, UUID uuid) {
        DeferredHolder registryObject = ATTRIBUTES.register(name, () -> (Attribute)attribute.apply(name));
        UUIDS.put((DeferredHolder<Attribute, Attribute>)registryObject, uuid);
        return registryObject;
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().stream().filter(e -> e == EntityType.PLAYER).forEach(e -> ATTRIBUTES.getEntries().forEach(v -> event.add(e, (Holder)v)));
    }
}

