/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class RitualContext {
    public int progress = 0;
    public boolean isDone = false;
    public boolean isStarted = false;
    public boolean needsSourceToRun = false;
    public List<ItemStack> consumedItems = new ArrayList<ItemStack>();

    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putInt("progress", this.progress);
        tag.putBoolean("complete", this.isDone);
        tag.putBoolean("started", this.isStarted);
        tag.putBoolean("needsMana", this.needsSourceToRun);
        NBTUtil.writeItems(provider, tag, "item_", this.consumedItems);
    }

    public static RitualContext read(HolderLookup.Provider provider, CompoundTag tag) {
        RitualContext context = new RitualContext();
        context.progress = tag.getInt("progress");
        context.isDone = tag.getBoolean("complete");
        context.isStarted = tag.getBoolean("started");
        context.consumedItems = NBTUtil.readItems(provider, tag, "item_");
        context.needsSourceToRun = tag.getBoolean("needsMana");
        return context;
    }
}

