/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ANExplosion
extends Explosion {
    public double amps;
    public double baseDamage;
    public double ampDamageScalar;

    public ANExplosion(Level p_i231610_1_, @Nullable Entity p_i231610_2_, @Nullable DamageSource p_i231610_3_, @Nullable ExplosionDamageCalculator p_i231610_4_, double p_i231610_5_, double p_i231610_7_, double p_i231610_9_, float p_i231610_11_, boolean p_i231610_12_, Explosion.BlockInteraction p_i231610_13_, double numAmps) {
        super(p_i231610_1_, p_i231610_2_, p_i231610_3_, p_i231610_4_, p_i231610_5_, p_i231610_7_, p_i231610_9_, p_i231610_11_, p_i231610_12_, p_i231610_13_, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
        this.amps = numAmps;
    }

    public void explode() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockState blockstate;
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, blockpos, blockstate = this.level.getBlockState(blockpos), fluidstate = this.level.getFluidState(blockpos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.floor((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.floor((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.floor((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.floor((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.floor((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.floor((double)(this.z + (double)f2 + 1.0));
        List list = this.level.getEntities(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);
        for (Entity entity : list) {
            Player playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (entity.ignoreExplosion((Explosion)this) || !((d12 = (double)(Mth.sqrt((float)((float)entity.distanceToSqr(vector3d))) / f2)) <= 1.0) || (d13 = (double)Mth.sqrt((float)((float)((d5 = entity.getX() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.y) * d7 + (d9 = entity.getZ() - this.z) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = ANExplosion.getSeenPercent((Vec3)vector3d, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            float damage = (float)Math.min((double)Math.max(0.0f, (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0))), this.baseDamage + this.amps * this.ampDamageScalar);
            entity.hurt(this.damageSource, damage);
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                d11 = d10 * (1.0 - livingEntity.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).isSpectator() || playerentity.isCreative() && playerentity.abilities.flying) continue;
            this.hitPlayers.put(playerentity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }
}

