/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectableButton;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.gui.NestedWidgets;
import com.hollingsworth.nuggets.client.rendering.RenderHelpers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;

public class DocEntryButton
extends SelectableButton
implements NestedWidgets {
    public ItemStack renderStack;
    public Component title;
    public DocAssets.BlitInfo icon;
    public Component fullTitle;
    public SelectableButton favoriteButton;
    protected Button.OnPress onFavorited;
    protected Supplier<Boolean> isFavorited;
    public TriFunction<Double, Double, Integer, Boolean> onClickFunction;

    public DocEntryButton(int x, int y, ItemStack renderStack, Component display, Button.OnPress onPress) {
        super(x, y, DocAssets.DOC_ENTRY_BUTTON, DocAssets.DOC_ENTRY_BUTTON_SELECTED, onPress);
        this.renderStack = renderStack;
        this.title = display;
        int length = 25;
        Object displayString = display.getString();
        if (display.getString().length() > length + 3) {
            this.fullTitle = display;
            displayString = display.getString().substring(0, length + 1).trim() + "...";
        }
        this.title = Component.literal((String)displayString);
    }

    public DocEntryButton(int x, int y, DocEntry docEntry, Button.OnPress onPress) {
        this(x, y, docEntry.renderStack(), docEntry.entryTitle(), onPress);
    }

    public DocEntryButton withStaticIcon(DocAssets.BlitInfo blitInfo) {
        this.icon = blitInfo;
        return this;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.favoriteButton != null) {
            if (!this.visible || !this.active) {
                this.favoriteButton.visible = true;
                this.favoriteButton.active = true;
                this.favoriteButton.x = -999999;
                this.favoriteButton.y = -999999;
            } else if (this.isFavorited.get().booleanValue() || this.isHovered()) {
                this.favoriteButton.visible = true;
                this.favoriteButton.active = true;
                this.favoriteButton.x = this.x + this.width - 10;
                this.favoriteButton.y = this.y + 4;
            } else {
                this.favoriteButton.visible = false;
                this.favoriteButton.active = false;
                this.favoriteButton.x = -999999;
                this.favoriteButton.y = -999999;
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int xOffset = 14;
        if (this.renderStack.isEmpty() && this.icon == null) {
            xOffset = 2;
            DocClientUtils.blit(graphics, DocAssets.CHAPTER_BUTTON_NO_ITEM, this.x, this.y);
        } else {
            super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
        }
        if (this.icon != null) {
            graphics.blit(this.icon.location(), this.x + 1, this.y + 1, 0.0f, 0.0f, 12, 12, 12, 12);
        }
        RenderHelpers.drawItemAsIcon((ItemStack)this.renderStack, (GuiGraphics)graphics, (int)(this.x - 1), (int)(this.y - 1), (int)10, (boolean)false);
        DocClientUtils.drawStringScaled(graphics, this.title, this.x + xOffset, this.y + 3, 0, 0.8f, false);
    }

    protected boolean isValidClickButton(int button) {
        return super.isValidClickButton(button) || this.onClickFunction != null && button == 1;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (GuiHelpers.isMouseInRelativeRange((double)mouseX, (double)mouseY, (AbstractWidget)this) && this.visible && this.active && this.onClickFunction != null && ((Boolean)this.onClickFunction.apply((Object)mouseX, (Object)mouseY, (Object)button)).booleanValue()) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void addBeforeParent(List<AbstractWidget> widgets) {
        if (this.onFavorited != null) {
            this.favoriteButton = new SelectableButton(0, 0, DocAssets.FAVORITE_ICON_HOVER, DocAssets.FAVORITE_ICON, b -> {
                this.onFavorited.onPress(b);
                this.favoriteButton.isSelected = this.isFavorited.get();
            });
            this.favoriteButton.isSelected = this.isFavorited.get();
            widgets.add((AbstractWidget)this.favoriteButton);
        }
    }

    public DocEntryButton setFavoritable(Supplier<Boolean> isFavorited, Button.OnPress onFavorited) {
        this.onFavorited = onFavorited;
        this.isFavorited = isFavorited;
        return this;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.fullTitle != null) {
            tooltip.add(this.fullTitle);
        }
        super.getTooltip(tooltip);
    }
}

