/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ArmorUpgradeRecipe;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ArmorUpgradeRecipeCategory
extends EnchantingApparatusRecipeCategory<ArmorUpgradeRecipe> {
    public ArmorUpgradeRecipeCategory(IGuiHelper helper) {
        super(helper);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ArmorUpgradeRecipe recipe, IFocusGroup focuses) {
        MultiInputCategory.MultiProvider provider = (MultiInputCategory.MultiProvider)this.multiProvider.apply(recipe);
        List<Ingredient> inputs = provider.input();
        double angleBetweenEach = 360.0 / (double)inputs.size();
        List<ItemStack> stacks = PerkRegistry.getPerkProviderItems().stream().filter(item -> {
            AnimatedMagicArmor ama;
            return item instanceof AnimatedMagicArmor && (ama = (AnimatedMagicArmor)item).getMinTier() < recipe.tier;
        }).map(Item::getDefaultInstance).toList();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (!focuses.isEmpty()) {
            List<ItemStack> list = focuses.getItemStackFocuses(RecipeIngredientRole.CATALYST).map(i -> ((ItemStack)i.getTypedValue().getIngredient()).copy()).filter(i -> i.getItem() instanceof AnimatedMagicArmor).toList();
            List<ItemStack> list2 = focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).map(i -> ((ItemStack)i.getTypedValue().getIngredient()).copy()).filter(i -> i.getItem() instanceof AnimatedMagicArmor).toList();
            if (!list.isEmpty()) {
                stacks = list;
            } else if (!list2.isEmpty()) {
                stacks = list2;
            }
        }
        for (ItemStack stack : stacks) {
            ItemStack copy = stack.copy();
            List<List<PerkSlot>> perkProvider = PerkRegistry.getPerkProvider(stack.getItem());
            if (perkProvider != null) {
                ArmorPerkHolder perkHolder = (ArmorPerkHolder)stack.getOrDefault(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder(null, List.of(), 0, new HashMap<IPerk, CompoundTag>()));
                stack.set(DataComponentRegistry.ARMOR_PERKS, (Object)perkHolder.setTier(recipe.tier - 1));
                ArmorPerkHolder copyHolder = (ArmorPerkHolder)copy.getOrDefault(DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder(null, List.of(), 0, new HashMap<IPerk, CompoundTag>()));
                copy.set(DataComponentRegistry.ARMOR_PERKS, (Object)copyHolder.setTier(recipe.tier));
            }
            outputs.add(copy);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 48, 45).addItemStacks(stacks);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 10).addItemStacks(outputs);
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)this.point.x, (int)this.point.y).addIngredients(input);
            this.point = ArmorUpgradeRecipeCategory.rotatePointAbout(this.point, this.center, angleBetweenEach);
        }
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"ars_nouveau.armor_upgrade");
    }

    @Override
    public RecipeType<ArmorUpgradeRecipe> getRecipeType() {
        return JEIArsNouveauPlugin.ARMOR_RECIPE_TYPE;
    }

    public void draw(ArmorUpgradeRecipe recipe, @NotNull IRecipeSlotsView slotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font renderer = Minecraft.getInstance().font;
        graphics.drawString(renderer, (Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{1 + recipe.tier}), 0, 0, 10, false);
        if (recipe.consumesSource()) {
            graphics.drawString(renderer, (Component)Component.translatable((String)"ars_nouveau.source", (Object[])new Object[]{recipe.sourceCost()}), 0, 100, 10, false);
        }
    }
}

