/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ParticleRenderTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.level.Level;

public class ParticleLine
extends TextureSheetParticle {
    public float colorR;
    public float colorG;
    public float colorB;
    public float initScale;
    public float initX;
    public float initY;
    public float initZ;
    public float destX;
    public float destY;
    public float destZ;

    protected ParticleLine(Level worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float scale, int lifetime, SpriteSet sprite) {
        super((ClientLevel)worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        if ((double)this.colorR > 1.0) {
            this.colorR /= 255.0f;
        }
        if ((double)this.colorG > 1.0) {
            this.colorG /= 255.0f;
        }
        if ((double)this.colorB > 1.0) {
            this.colorB /= 255.0f;
        }
        this.setColor(this.colorR, this.colorG, this.colorB);
        this.lifetime = lifetime;
        this.quadSize = scale;
        this.initScale = scale;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.initX = (float)x;
        this.initY = (float)y;
        this.initZ = (float)z;
        this.destX = (float)vx;
        this.destY = (float)vy;
        this.destZ = (float)vz;
        this.roll = (float)Math.PI * 2;
        this.pickSprite(sprite);
    }

    public void tick() {
        super.tick();
        if (this.level.random.nextInt(6) == 0) {
            ++this.age;
        }
        float lifeCoeff = (float)this.age / (float)this.lifetime;
        this.x = (1.0f - lifeCoeff) * this.initX + lifeCoeff * this.destX;
        this.y = (1.0f - lifeCoeff) * this.initY + lifeCoeff * this.destY;
        this.z = (1.0f - lifeCoeff) * this.initZ + lifeCoeff * this.destZ;
        this.quadSize = this.initScale - this.initScale * lifeCoeff;
        this.alpha = 1.0f - lifeCoeff;
        this.oRoll = this.roll;
    }

    public boolean isAlive() {
        return this.age < this.lifetime;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.EMBER_RENDER;
    }

    public int getLightColor(float pTicks) {
        return 255;
    }
}

