/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ItemDetectorTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ItemDetector
extends TickableModBlock {
    public static final VoxelShape shape = Shapes.join((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (BooleanOp)BooleanOp.OR);

    public ItemDetector(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemDetector() {
        super(ItemDetector.defaultProperties().noOcclusion());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ItemDetectorTile(pPos, pState);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (handIn == InteractionHand.MAIN_HAND) {
            BlockEntity blockEntity;
            if (worldIn.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() instanceof DominionWand || !((blockEntity = worldIn.getBlockEntity(pos)) instanceof ItemDetectorTile)) {
                return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
            }
            ItemDetectorTile itemDetector = (ItemDetectorTile)blockEntity;
            if (stack.isEmpty()) {
                itemDetector.addCount(player.isShiftKeyDown() ? 8 : 1);
            } else if (!stack.isEmpty()) {
                itemDetector.setFilterStack(stack.copy());
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ItemDetectorTile) {
            ItemDetectorTile tile = (ItemDetectorTile)blockEntity;
            tile.addCount(player.isShiftKeyDown() ? -8 : -1);
        }
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntity = pBlockAccess.getBlockEntity(pPos);
        if (blockEntity instanceof ItemDetectorTile) {
            ItemDetectorTile detectorTile = (ItemDetectorTile)blockEntity;
            return detectorTile.getPoweredState() ? 15 : 0;
        }
        return 0;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

