/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ImbuementRecipe
implements IImbuementRecipe {
    public final Ingredient input;
    public final ItemStack output;
    public final int source;
    public List<Ingredient> pedestalItems;
    public ResourceLocation id;
    private NonNullList<Ingredient> ingredients;

    public ImbuementRecipe(Ingredient input, ItemStack output, int source, List<Ingredient> pedestalItems) {
        this.input = input;
        this.output = output;
        this.source = source;
        this.pedestalItems = pedestalItems;
        this.ingredients = NonNullList.createWithCapacity((int)(pedestalItems.size() + 1));
        this.ingredients.add((Object)input);
        this.ingredients.addAll(pedestalItems);
    }

    public ImbuementRecipe(String id, Ingredient ingredient, ItemStack output, int source) {
        this(ArsNouveau.prefix(id), ingredient, output, source);
    }

    public ImbuementRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, int source) {
        this(ingredient, output, source, new ArrayList<Ingredient>());
        this.id = id;
    }

    public ImbuementRecipe withPedestalItem(Ingredient i) {
        this.pedestalItems.add(i);
        return this;
    }

    public ImbuementRecipe withPedestalItem(ItemLike i) {
        this.pedestalItems.add(Ingredient.of((ItemLike[])new ItemLike[]{i}));
        return this;
    }

    @Override
    public int getSourceCost(ImbuementTile imbuementTile) {
        return this.source;
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return this.input.test(reag);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getSource() {
        return this.source;
    }

    public List<Ingredient> getPedestalItems() {
        return this.pedestalItems;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(ImbuementTile pContainer, Level pLevel) {
        return this.input.test(pContainer.getItem(0)) && EnchantingApparatusRecipe.doItemsMatch(pContainer.getPedestalItems(), this.pedestalItems);
    }

    public ItemStack assemble(ImbuementTile pCraftingContainer, HolderLookup.Provider pRegistries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.IMBUEMENT_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(ArsNouveau.prefix("imbuement"));
    }

    public static class Serializer
    implements RecipeSerializer<ImbuementRecipe> {
        public static final MapCodec<ImbuementRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(ImbuementRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(ImbuementRecipe::getOutput), (App)Codec.INT.fieldOf("source").forGetter(ImbuementRecipe::getSource), (App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(ImbuementRecipe::getPedestalItems)).apply((Applicative)instance, ImbuementRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ImbuementRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buf, ImbuementRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            for (Ingredient i : recipe.pedestalItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)i);
            }
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.output);
            buf.writeInt(recipe.source);
        }

        public static ImbuementRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int length = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new ImbuementRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readInt(), stacks);
        }

        public MapCodec<ImbuementRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ImbuementRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

