/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SummonRitualRecipe
implements SpecialSingleInputRecipe {
    public final Ingredient augment;
    public final MobSource mobSource;
    public final int count;
    public final WeightedRandomList<WeightedMobType> mobs;

    public SummonRitualRecipe(Ingredient augment, MobSource source, int count, WeightedRandomList<WeightedMobType> mobs) {
        this.augment = augment;
        this.mobSource = source;
        this.count = count;
        this.mobs = mobs;
    }

    public SummonRitualRecipe(Ingredient augment, String source, int count, List<WeightedMobType> mobs) {
        this.augment = augment;
        this.mobSource = MobSource.valueOf(source);
        this.count = count;
        this.mobs = WeightedRandomList.create(mobs);
    }

    public SummonRitualRecipe(Ingredient augment, String source, int count, WeightedRandomList<WeightedMobType> mobs) {
        this(augment, MobSource.valueOf(source), count, mobs);
    }

    public SummonRitualRecipe(Ingredient augment, MobSource source, int count) {
        this(augment, source, count, (WeightedRandomList<WeightedMobType>)WeightedRandomList.create());
    }

    public boolean matches(List<ItemStack> augments) {
        return EnchantingApparatusRecipe.doItemsMatch(augments, Arrays.stream(this.augment.getItems()).map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).toList());
    }

    public boolean matches(SingleRecipeInput p_346065_, Level p_345375_) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.SUMMON_RITUAL_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.SUMMON_RITUAL_TYPE.get();
    }

    public static enum MobSource {
        CURRENT_BIOME,
        MOB_LIST;

    }

    public record WeightedMobType(ResourceLocation mob, int weight) implements WeightedEntry
    {
        public static final MapCodec<WeightedMobType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("mob").forGetter(WeightedMobType::mob), (App)Codec.INT.fieldOf("weight").forGetter(WeightedMobType::weight)).apply((Applicative)instance, WeightedMobType::new));

        public WeightedMobType(ResourceLocation mob) {
            this(mob, 1);
        }

        @NotNull
        public Weight getWeight() {
            return Weight.of((int)this.weight);
        }
    }

    public static class Serializer
    implements RecipeSerializer<SummonRitualRecipe> {
        public static final MapCodec<SummonRitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("augment").forGetter(r -> r.augment), (App)Codec.STRING.fieldOf("mobSource").fieldOf("source").forGetter(r -> r.mobSource.toString()), (App)Codec.INT.fieldOf("count").forGetter(r -> r.count), (App)Codec.list((Codec)WeightedMobType.CODEC.codec()).fieldOf("mobs").forGetter(r -> r.mobs.unwrap())).apply((Applicative)instance, SummonRitualRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SummonRitualRecipe> STREAM_CODEC = CheatSerializer.create(CODEC);

        public MapCodec<SummonRitualRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SummonRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

