/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.HelixParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class PacketANEffect
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketANEffect> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketANEffect> CODEC = StreamCodec.ofMember(PacketANEffect::toBytes, PacketANEffect::decode);
    private final EffectType type;
    private final double x;
    private final double y;
    private final double z;
    private final CompoundTag particleNbt;
    private final int[] args;

    public PacketANEffect(EffectType type, double x, double y, double z, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        ParticleColor defaultColor = new ParticleColor(255, 25, 180);
        this.particleNbt = defaultColor.serialize();
        this.args = args;
    }

    public PacketANEffect(EffectType type, double x, double y, double z, ParticleColor color, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.particleNbt = color.serialize();
        this.args = args;
    }

    public PacketANEffect(EffectType type, BlockPos pos, int ... args) {
        this(type, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), args);
    }

    public PacketANEffect(EffectType type, BlockPos pos, ParticleColor wrapper, int ... args) {
        this(type, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), wrapper, args);
    }

    public static PacketANEffect decode(RegistryFriendlyByteBuf buf) {
        EffectType type = EffectType.values()[buf.readByte()];
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        CompoundTag nbt = buf.readNbt();
        int[] args = new int[type.argCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buf.readVarInt();
        }
        return new PacketANEffect(type, x, y, z, ParticleColorRegistry.from(nbt), args);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeNbt((Tag)this.particleNbt);
        for (int i = 0; i < this.type.argCount; ++i) {
            buf.writeVarInt(this.args[i]);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        ClientLevel world = minecraft.level;
        ParticleColor color = ParticleColorRegistry.from(this.particleNbt);
        switch (this.type.ordinal()) {
            case 2: {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.x + 0.5;
                    double d1 = this.y + 1.2;
                    double d2 = this.z + 0.5;
                    world.addAlwaysVisibleParticle(GlowParticleData.createData(color), true, d0, d1, d2, ((double)world.random.nextFloat() - 0.5) / 3.0, ((double)world.random.nextFloat() - 0.5) / 3.0, ((double)world.random.nextFloat() - 0.5) / 3.0);
                }
                break;
            }
            case 1: {
                int numParticles = 8;
                for (int i = 0; i < numParticles; ++i) {
                    world.addAlwaysVisibleParticle(HelixParticleData.createData(color, 0.25f, 1.0f, 50, (float)i * 360.0f / (float)numParticles), true, this.x + 0.5, this.y + 0.1 * (double)i, this.z + 0.5, 0.0, 0.0, 0.0);
                }
                break;
            }
        }
    }

    public static enum EffectType {
        TIMED_GLOW(4),
        TIMED_HELIX(0),
        BURST(0);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }
}

