/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.Lily;
import com.hollingsworth.arsnouveau.common.entity.Nook;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class PacketSummonDog
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSummonDog> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("summon_dog"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSummonDog> CODEC = StreamCodec.ofMember(PacketSummonDog::toBytes, PacketSummonDog::new);
    public DogType dogType;

    public PacketSummonDog(DogType summonNook) {
        this.dogType = summonNook;
    }

    public PacketSummonDog(RegistryFriendlyByteBuf buf) {
        this.dogType = (DogType)buf.readEnum(DogType.class);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.dogType);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (this.dogType == DogType.NOOK) {
            Nook nook = new Nook(player.level);
            nook.setPos(player.getX(), player.getY(), player.getZ());
            nook.setOwnerUUID(player.getUUID());
            player.level.addFreshEntity((Entity)nook);
            Nook.ownerNookMap.put((Object)player.getUUID(), (Object)nook.getUUID());
        } else {
            Lily lily = new Lily(player.level);
            lily.setPos(player.getX(), player.getY(), player.getZ());
            lily.setOwnerUUID(player.getUUID());
            player.level.addFreshEntity((Entity)lily);
            Lily.ownerLilyMap.put((Object)player.getUUID(), (Object)lily.getUUID());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum DogType {
        NOOK,
        LILY;

    }
}

