/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import java.util.List;
import org.apache.lucene.ars_nouveau.document.ShapeDocValues;
import org.apache.lucene.ars_nouveau.document.ShapeField;
import org.apache.lucene.ars_nouveau.geo.GeoEncodingUtils;
import org.apache.lucene.ars_nouveau.geo.Point;
import org.apache.lucene.ars_nouveau.geo.Rectangle;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public final class LatLonShapeDocValues
extends ShapeDocValues {
    protected LatLonShapeDocValues(List<ShapeField.DecodedTriangle> tessellation) {
        super(tessellation);
    }

    protected LatLonShapeDocValues(BytesRef binaryValue) {
        super(binaryValue);
    }

    @Override
    public Point getCentroid() {
        return (Point)this.centroid;
    }

    @Override
    public Rectangle getBoundingBox() {
        return (Rectangle)this.boundingBox;
    }

    @Override
    protected Point computeCentroid() {
        ShapeDocValues.Encoder encoder = this.getEncoder();
        return new Point(encoder.decodeY(this.getEncodedCentroidY()), encoder.decodeX(this.getEncodedCentroidX()));
    }

    @Override
    protected Rectangle computeBoundingBox() {
        ShapeDocValues.Encoder encoder = this.getEncoder();
        return new Rectangle(encoder.decodeY(this.getEncodedMinY()), encoder.decodeY(this.getEncodedMaxY()), encoder.decodeX(this.getEncodedMinX()), encoder.decodeX(this.getEncodedMaxX()));
    }

    @Override
    protected ShapeDocValues.Encoder getEncoder() {
        return new ShapeDocValues.Encoder(this){

            @Override
            public int encodeX(double x) {
                return GeoEncodingUtils.encodeLongitude(x);
            }

            @Override
            public int encodeY(double y) {
                return GeoEncodingUtils.encodeLatitude(y);
            }

            @Override
            public double decodeX(int encoded) {
                return GeoEncodingUtils.decodeLongitude(encoded);
            }

            @Override
            public double decodeY(int encoded) {
                return GeoEncodingUtils.decodeLatitude(encoded);
            }
        };
    }
}

