/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.store;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.store.IndexInput;

public abstract class ChecksumIndexInput
extends IndexInput {
    private static final int SKIP_BUFFER_SIZE = 1024;
    private byte[] skipBuffer;

    protected ChecksumIndexInput(String resourceDescription) {
        super(resourceDescription);
    }

    public abstract long getChecksum() throws IOException;

    @Override
    public void seek(long pos) throws IOException {
        long curFP = this.getFilePointer();
        long skip = pos - curFP;
        if (skip < 0L) {
            throw new IllegalStateException(String.valueOf(this.getClass()) + " cannot seek backwards (pos=" + pos + " getFilePointer()=" + curFP + ")");
        }
        this.skipByReading(skip);
    }

    private void skipByReading(long numBytes) throws IOException {
        int step;
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (long skipped = 0L; skipped < numBytes; skipped += (long)step) {
            step = (int)Math.min(1024L, numBytes - skipped);
            this.readBytes(this.skipBuffer, 0, step, false);
        }
    }
}

