/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.config.data;

import it.hurts.octostudios.octolib.module.config.annotation.Prop;
import it.hurts.sskirillss.relics.config.data.LootEntryConfigData;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import java.util.List;

public class LootConfigData {
    @Prop(comment="List of conditions for obtaining the relic. Supports both direct ID specification and regular expressions.")
    private List<LootEntryConfigData> entries;

    public LootData toData(IRelicItem relic) {
        LootData data = relic.getLootData();
        data.setEntries(this.entries.stream().map(entry -> new LootEntry(entry.getDimensions(), entry.getBiomes(), entry.getTables(), entry.getWeight())).toList());
        return data;
    }

    public List<LootEntryConfigData> getEntries() {
        return this.entries;
    }

    public void setEntries(List<LootEntryConfigData> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootConfigData)) {
            return false;
        }
        LootConfigData other = (LootConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LootEntryConfigData> this$entries = this.getEntries();
        List<LootEntryConfigData> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootConfigData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LootEntryConfigData> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public String toString() {
        return "LootConfigData(entries=" + String.valueOf(this.getEntries()) + ")";
    }

    public LootConfigData() {
    }

    public LootConfigData(List<LootEntryConfigData> entries) {
        this.entries = entries;
    }
}

