/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions;

import com.github.eterdelta.crittersandcompanions.AddItemModifier;
import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.CrittersAndCompanionsClient;
import com.github.eterdelta.crittersandcompanions.ReplaceItemModifier;
import com.github.eterdelta.crittersandcompanions.handler.PlayerHandler;
import com.github.eterdelta.crittersandcompanions.platform.ForgeConfigs;
import com.github.eterdelta.crittersandcompanions.platform.ForgeNetwork;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="crittersandcompanions")
@EventBusSubscriber(modid="crittersandcompanions", bus=EventBusSubscriber.Bus.MOD)
public class CrittersAndCompanionsForge {
    public CrittersAndCompanionsForge(ModContainer container, IEventBus modBus) {
        CrittersAndCompanions.init();
        ForgeNetwork.register(modBus);
        ForgeConfigs.register(container);
        modBus.addListener(event -> event.enqueueWork(CrittersAndCompanions::setup));
        modBus.addListener(event -> event.enqueueWork(CrittersAndCompanionsClient::init));
        DeferredRegister lootModifiers = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"crittersandcompanions");
        lootModifiers.register("replace_item", () -> ReplaceItemModifier.CODEC);
        lootModifiers.register("add_item", () -> AddItemModifier.CODEC);
        lootModifiers.register(modBus);
    }

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)"crittersandcompanions", (String)"resourcepacks/friendlyart"), PackType.CLIENT_RESOURCES, (Component)Component.literal((String)"Friendly Critter Art"), PackSource.BUILT_IN, false, Pack.Position.BOTTOM);
    }

    @SubscribeEvent
    public static void onAttributeCreation(EntityAttributeCreationEvent event) {
        CrittersAndCompanions.onAttributeCreation((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
    }

    @EventBusSubscriber(modid="crittersandcompanions")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
            UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), null);
            InteractionResult result = PlayerHandler.onPlayerEntityInteract(event.getTarget(), context);
            if (result != null) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            PlayerHandler.onPlayerTick(event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
            PlayerHandler.onPlayerStartTracking(event.getTarget(), (Entity)event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerStopTracking(PlayerEvent.StopTracking event) {
            PlayerHandler.onPlayerStopTracking(event.getTarget(), (Entity)event.getEntity());
        }
    }
}

