/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.brain.OtterNavigation;
import com.github.eterdelta.crittersandcompanions.entity.brain.OtterPanicGoal;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OtterEntity
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> FLOATING = SynchedEntityData.defineId(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final TagKey<Item> FOODS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrittersAndCompanions.createId("otter_food"));
    private static final Vec3i UNDERWATER_PICKUP_REACH = new Vec3i(1, 1, 1);
    private boolean needsSurface;
    private int huntDelay;
    private int eatDelay;
    private int floatTime;

    public OtterEntity(EntityType<? extends OtterEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new OtterMoveControl(this);
        this.lookControl = new OtterLookControl(this);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public static boolean checkOtterSpawnRules(EntityType<OtterEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        return blockPos.getY() > levelAccessor.getSeaLevel() - 16;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLOATING, (Object)false);
        builder.define(EATING, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new OtterPanicGoal(this, 1.6f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 32.0f, 0.9, 1.5, livingEntity -> livingEntity.equals((Object)this.getLastHurtMob())));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(3, (Goal)new GoToSurfaceGoal(60));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal(this));
        this.goalSelector.addGoal(5, (Goal)new SearchFoodGoal());
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal(this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal(this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal(this));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 20, false, false, fish -> fish instanceof AbstractSchoolingFish && this.getHuntDelay() <= 0));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("HuntDelay", this.getHuntDelay());
        compound.putBoolean("Floating", this.isFloating());
        compound.putInt("FloatTime", this.floatTime);
        compound.putBoolean("Eating", this.isEating());
        compound.putInt("EatDelay", this.eatDelay);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.huntDelay = compound.getInt("HuntDelay");
        this.setFloating(compound.getBoolean("Floating"));
        this.floatTime = compound.getInt("FloatTime");
        this.setEating(compound.getBoolean("Eating"));
        this.eatDelay = compound.getInt("EatDelay");
    }

    public void awardKillScore(Entity killedEntity, int i, DamageSource damageSource) {
        super.awardKillScore(killedEntity, i, damageSource);
        if (killedEntity instanceof AbstractSchoolingFish) {
            this.huntDelay = 6000;
        }
    }

    protected int getBaseExperienceReward() {
        return this.random.nextInt(3, 7);
    }

    public void baseTick() {
        super.baseTick();
        if (this.getLastHurtMob() != null && this.tickCount - this.getLastHurtMobTimestamp() > 100) {
            this.setLastHurtMob(null);
        }
        if (this.tickCount % 60 == 0) {
            this.heal(0.5f);
        }
    }

    public void tick() {
        super.tick();
        if (!this.isInWater()) {
            this.setXRot(0.0f);
            this.xRotO = 0.0f;
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.isControlledByLocalInstance()) {
            ItemStack held;
            if (this.isFloating()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                this.setYya(0.0f);
                this.setAirSupply(this.getMaxAirSupply());
                if (--this.floatTime <= 0) {
                    this.setFloating(false);
                }
            }
            if (this.isUnderWater() && (this.getAirSupply() < 200 || this.random.nextFloat() <= 0.001f)) {
                this.setNeedsSurface(true);
            }
            if (this.isFood(held = this.getMainHandItem())) {
                if (this.isEating()) {
                    if (this.eatDelay > 0) {
                        --this.eatDelay;
                    } else {
                        Level level = this.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel level2 = (ServerLevel)level;
                            this.breakAndEat(level2, held);
                        }
                    }
                } else if (this.isInWater()) {
                    if (this.isFloating()) {
                        this.startEating();
                    } else {
                        this.setNeedsSurface(true);
                    }
                } else if (this.onGround()) {
                    this.startEating();
                }
            }
            if (this.huntDelay > 0) {
                --this.huntDelay;
            }
        }
    }

    private boolean breakingClamOnLand() {
        boolean floating = this.isInWater() || this.isFloating();
        return !floating && this.getMainHandItem().is((Item)CACItems.CLAM.get());
    }

    private void breakAndEat(ServerLevel level, ItemStack held) {
        Vec3 mouthPos = this.calculateMouthPos();
        level.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, held.copy()), mouthPos.x(), mouthPos.y(), mouthPos.z(), 2, 0.0, 0.1, 0.0, 0.05);
        SoundEvent sound = this.getMainHandItem().is((Item)CACItems.CLAM.get()) && !this.breakingClamOnLand() ? (SoundEvent)CACSounds.OTTER_CLAM_BREAK.get() : (SoundEvent)CACSounds.OTTER_EAT.get();
        this.playSound(sound, 1.2f, 1.0f);
        this.eatOrOpen((Level)level, held);
        this.setEating(false);
    }

    public ItemStack eatOrOpen(Level level, ItemStack itemStack) {
        if (itemStack.is((Item)CACItems.CLAM.get())) {
            if (this.random.nextFloat() <= 0.07f) {
                Vec3 mouthPos = this.calculateMouthPos();
                ItemEntity pearl = new ItemEntity(level, mouthPos.x(), mouthPos.y(), mouthPos.z(), new ItemStack((ItemLike)CACItems.PEARL.get()));
                pearl.setDeltaMovement(this.getRandom().nextGaussian() * 0.05, this.getRandom().nextGaussian() * 0.05 + 0.2, this.getRandom().nextGaussian() * 0.05);
                level.addFreshEntity((Entity)pearl);
            }
            level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TURTLE_EGG_BREAK, SoundSource.NEUTRAL, 0.8f, 1.5f);
            itemStack.shrink(1);
            return itemStack;
        }
        return this.eat(level, itemStack);
    }

    public float getScale() {
        return this.isBaby() ? 0.6f : 1.0f;
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (this.rejectedItem(itemEntity)) {
            return;
        }
        super.pickUpItem(itemEntity);
    }

    protected PathNavigation createNavigation(Level level) {
        return new OtterNavigation((Mob)this, level);
    }

    public int getMaxAirSupply() {
        return 9600;
    }

    protected void jumpInLiquid(TagKey<Fluid> fluidTag) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.08f * this.getAttribute(Services.PLATFORM.getSwimSpeedAttribute()).getValue(), 0.0));
    }

    public void travel(Vec3 speed) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), speed);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            this.calculateEntityAnimation(false);
        } else {
            super.travel(speed);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack handStack = player.getItemInHand(interactionHand);
        if (!this.isEating() && this.isFood(handStack)) {
            this.setItemInHand(InteractionHand.MAIN_HAND, handStack.split(1));
            handStack.shrink(1);
            return super.mobInteract(player, interactionHand);
        }
        return InteractionResult.PASS;
    }

    public boolean canHoldItem(ItemStack itemStack) {
        return this.isFood(itemStack) && this.isHungryAt(itemStack);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(FOODS_TAG);
    }

    public boolean canBreed() {
        return !this.isBaby();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        OtterEntity otter = (OtterEntity)((EntityType)CACEntities.OTTER.get()).create((Level)level);
        return otter;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            this.playSound((SoundEvent)CACSounds.BITE_ATTACK.get(), this.getSoundVolume(), this.getVoicePitch());
            return true;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)CACSounds.OTTER_AMBIENT.get();
    }

    protected SoundEvent getSwimSound() {
        return (SoundEvent)CACSounds.OTTER_SWIM.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)CACSounds.OTTER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)CACSounds.OTTER_DEATH.get();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        if (mobSpawnType.equals((Object)MobSpawnType.SPAWNER) && this.random.nextFloat() <= 0.2f) {
            for (int i = 0; i < this.random.nextInt(1, 4); ++i) {
                OtterEntity baby = (OtterEntity)((EntityType)CACEntities.OTTER.get()).create(this.level());
                baby.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                baby.setBaby(true);
                levelAccessor.addFreshEntity((Entity)baby);
            }
        }
        return spawnGroupData;
    }

    private RawAnimation animation(AnimationState<?> event) {
        if (this.isFloating()) {
            return RawAnimation.begin().thenLoop("swim_2");
        }
        if (this.isEating()) {
            if (this.getMainHandItem().is((Item)CACItems.CLAM.get())) {
                return RawAnimation.begin().then("standing_eat_clam", Animation.LoopType.PLAY_ONCE);
            }
            return RawAnimation.begin().then("standing_eat", Animation.LoopType.PLAY_ONCE);
        }
        if (this.isInWater()) {
            return RawAnimation.begin().thenLoop("swim");
        }
        if (event.isMoving()) {
            if (this.getDeltaMovement().length() >= (double)0.18f) {
                return RawAnimation.begin().thenLoop("run");
            }
            return RawAnimation.begin().thenLoop("walk");
        }
        return RawAnimation.begin().thenLoop("idle");
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(this.animation(event));
        return PlayState.CONTINUE;
    }

    private PlayState floatingHandsPredicate(AnimationState<?> event) {
        if (this.isFloating() && this.isEating()) {
            event.getController().setAnimation(RawAnimation.begin().then("floating_eat", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "floating_hands_controller", 4, this::floatingHandsPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isHungryAt(ItemStack foodStack) {
        return foodStack.is((Item)CACItems.CLAM.get()) || this.getInLoveTime() <= 0;
    }

    public void rejectFood() {
        if (!this.getMainHandItem().isEmpty()) {
            ItemStack thrownAway = this.getMainHandItem().copy();
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), thrownAway);
            itemEntity.setPickUpDelay(40);
            itemEntity.setThrower((Entity)this);
            this.getMainHandItem().shrink(thrownAway.getCount());
            this.level().addFreshEntity((Entity)itemEntity);
        }
    }

    public boolean rejectedItem(ItemEntity itemEntity) {
        if (itemEntity.getOwner() != null) {
            return itemEntity.getOwner().equals((Object)this.getUUID());
        }
        return false;
    }

    private void startEating() {
        if (this.isFood(this.getMainHandItem())) {
            this.eatDelay = this.getMainHandItem().is((Item)CACItems.CLAM.get()) ? 45 : 12;
            this.setEating(true);
            if (this.breakingClamOnLand()) {
                this.playSound((SoundEvent)CACSounds.OTTER_CLAM_BREAK_LAND.get(), 1.2f, 1.0f);
            }
        }
    }

    private void startFloating(int time) {
        this.floatTime = time;
        this.setFloating(true);
    }

    public Vec3 calculateMouthPos() {
        Vec3 viewVector = this.getViewVector(0.0f).scale(this.isFloating() ? 0.3 : 0.6).add(0.0, this.isFloating() ? 0.55 : 0.0, 0.0).scale((double)this.getScale());
        return new Vec3(this.getX() + viewVector.x(), this.getY() + viewVector.y(), this.getZ() + viewVector.z());
    }

    public int getHuntDelay() {
        return this.huntDelay;
    }

    public boolean needsSurface() {
        return this.needsSurface;
    }

    public void setNeedsSurface(boolean needsSurface) {
        this.needsSurface = needsSurface;
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(EATING, (Object)eating);
    }

    public boolean isFloating() {
        return (Boolean)this.entityData.get(FLOATING);
    }

    public void setFloating(boolean floating) {
        this.entityData.set(FLOATING, (Object)floating);
    }

    public int getMaxFallDistance() {
        if (this.isUnderWater()) {
            return 16;
        }
        return super.getMaxFallDistance();
    }

    protected Vec3i getPickupReach() {
        if (this.isUnderWater()) {
            return UNDERWATER_PICKUP_REACH;
        }
        return super.getPickupReach();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private boolean isReadyToFloat() {
        BlockPos eye = BlockPos.containing((double)this.getX(), (double)(this.getEyeY() + 0.25), (double)this.getZ());
        return !this.isUnderWater() && this.level().getBlockState(eye).isAir() && this.level().getFluidState(eye.below()).is(FluidTags.WATER);
    }

    private Vec3 findSurfacePosStraightUp() {
        BlockPos.MutableBlockPos curr = new BlockPos.MutableBlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getEyeY()), Mth.floor((double)this.getZ()));
        boolean waterInSight = false;
        for (int i = 0; i < 40; ++i) {
            BlockPos pos = curr.above(i);
            if (this.level().getFluidState(pos).is(FluidTags.WATER)) {
                waterInSight = true;
                continue;
            }
            if (!waterInSight || !this.level().getBlockState(pos).isAir()) continue;
            return Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.25, 0.0);
        }
        return null;
    }

    static class OtterMoveControl
    extends MoveControl {
        private final OtterEntity otter;

        public OtterMoveControl(OtterEntity otterEntity) {
            super((Mob)otterEntity);
            this.otter = otterEntity;
        }

        public void tick() {
            if (this.otter.isInWater()) {
                if (!this.otter.needsSurface()) {
                    this.otter.setDeltaMovement(this.otter.getDeltaMovement().add(this.otter.getLookAngle().scale(this.otter.isFloating() ? (double)0.002f : (double)0.005f)));
                }
                if (!this.otter.isFloating()) {
                    if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
                        double d2;
                        double d1;
                        double d0 = this.wantedX - this.mob.getX();
                        double distanceSqr = d0 * d0 + (d1 = this.wantedY - this.mob.getY()) * d1 + (d2 = this.wantedZ - this.mob.getZ()) * d2;
                        if (distanceSqr < 2.500000277905201E-7) {
                            this.mob.setZza(0.0f);
                        } else {
                            float yRot = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), yRot, 40.0f));
                            this.mob.yBodyRot = this.mob.getYRot();
                            this.mob.yHeadRot = this.mob.getYRot();
                            float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                            this.mob.setSpeed(speed * 0.2f);
                            double horizontalDistance = Math.sqrt(d0 * d0 + d2 * d2);
                            if (Math.abs(d1) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
                                float xRot = -((float)(Mth.atan2((double)d1, (double)horizontalDistance) * 57.2957763671875));
                                xRot = Mth.clamp((float)Mth.wrapDegrees((float)xRot), (float)-180.0f, (float)180.0f);
                                if (this.otter.needsSurface() && xRot > 0.0f) {
                                    xRot = 0.0f;
                                }
                                this.mob.setXRot(this.rotlerp(this.mob.getXRot(), xRot, 45.0f));
                            }
                            BlockPos wantedPos = BlockPos.containing((double)this.wantedX, (double)this.wantedY, (double)this.wantedZ);
                            BlockState wantedBlockState = this.mob.level().getBlockState(wantedPos);
                            if (d1 > 0.6 && d0 * d0 + d2 * d2 < 4.0 && d1 <= 1.0 && wantedBlockState.getFluidState().isEmpty()) {
                                this.mob.getJumpControl().jump();
                                float waterFactor = 0.14f;
                                if (this.otter.needsSurface()) {
                                    waterFactor = 0.08f;
                                }
                                this.mob.setSpeed(speed * waterFactor);
                            }
                            float f0 = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                            float f1 = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                            this.mob.zza = f0 * speed;
                            this.mob.yya = -f1 * speed;
                        }
                    } else {
                        this.mob.setSpeed(0.0f);
                        this.mob.setXxa(0.0f);
                        this.mob.setYya(0.0f);
                        this.mob.setZza(0.0f);
                    }
                }
            } else {
                super.tick();
            }
        }
    }

    static class OtterLookControl
    extends LookControl {
        private final OtterEntity otter;

        public OtterLookControl(OtterEntity otterEntity) {
            super((Mob)otterEntity);
            this.otter = otterEntity;
        }

        public void tick() {
            if (this.otter.isInWater()) {
                if (this.lookAtCooldown > 0) {
                    --this.lookAtCooldown;
                    this.getYRotD().ifPresent(p_181134_ -> {
                        this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, p_181134_.floatValue() + 20.0f, this.yMaxRotSpeed);
                    });
                    this.getXRotD().ifPresent(p_181132_ -> this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), p_181132_.floatValue() + 10.0f, this.xMaxRotAngle)));
                } else {
                    if (this.mob.getNavigation().isDone()) {
                        this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), 0.0f, 5.0f));
                    }
                    this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, this.yMaxRotSpeed);
                }
            } else {
                super.tick();
            }
        }
    }

    public class GoToSurfaceGoal
    extends Goal {
        private final int timeoutTime;
        private boolean goingLand;
        private Vec3 targetPos;
        private int timeoutTimer;
        private int stuckTicks;
        private double lastDist = Double.MAX_VALUE;

        public GoToSurfaceGoal(int timeoutTime) {
            this.timeoutTime = timeoutTime;
            this.timeoutTimer = timeoutTime;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return OtterEntity.this.isAlive() && OtterEntity.this.needsSurface() && !OtterEntity.this.onGround() && !OtterEntity.this.isFloating();
        }

        private void searchTargetPos() {
            Vec3 surface;
            if (OtterEntity.this.isInWater() && OtterEntity.this.isFood(OtterEntity.this.getMainHandItem()) && (surface = OtterEntity.this.findSurfacePosStraightUp()) != null) {
                this.targetPos = surface;
                return;
            }
            surface = OtterEntity.this.findSurfacePosStraightUp();
            if (surface != null) {
                this.targetPos = surface;
                return;
            }
            this.targetPos = this.findAirPosition();
        }

        public void start() {
            this.stuckTicks = 0;
            this.lastDist = Double.MAX_VALUE;
            this.searchTargetPos();
        }

        public void tick() {
            double absDy;
            if (OtterEntity.this.level().isClientSide) {
                return;
            }
            if (OtterEntity.this.isReadyToFloat()) {
                OtterEntity.this.setDeltaMovement(OtterEntity.this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                OtterEntity.this.setYya(0.0f);
                OtterEntity.this.setSpeed(0.0f);
                OtterEntity.this.startFloating(OtterEntity.this.getRandom().nextInt(80, 201));
                this.stop();
                return;
            }
            if (this.targetPos == null || !OtterEntity.this.level().getBlockState(BlockPos.containing((Position)this.targetPos)).isAir()) {
                this.searchTargetPos();
                this.tickTimeout();
                return;
            }
            OtterEntity.this.getLookControl().setLookAt(this.targetPos.x(), this.targetPos.y(), this.targetPos.z(), 85.0f, 85.0f);
            OtterEntity.this.getNavigation().moveTo(this.targetPos.x(), this.targetPos.y(), this.targetPos.z(), 0.5);
            double dx = this.targetPos.x() - OtterEntity.this.getX();
            double dy = this.targetPos.y() - OtterEntity.this.getEyePosition().y();
            double dz = this.targetPos.z() - OtterEntity.this.getZ();
            double horiz = dx * dx + dz * dz;
            boolean navDone = OtterEntity.this.getNavigation().isDone();
            double basePush = 0.02;
            if (dy > 0.0 && OtterEntity.this.isUnderWater()) {
                if (navDone || horiz <= 0.25) {
                    Vec3 v = OtterEntity.this.getDeltaMovement();
                    OtterEntity.this.setDeltaMovement(v.x * 0.6, v.y + 0.01, v.z * 0.6);
                } else if (horiz <= 9.0) {
                    OtterEntity.this.push(0.0, basePush, 0.0);
                }
            }
            if ((absDy = Math.abs(dy)) <= 0.85725) {
                OtterEntity.this.setDeltaMovement(OtterEntity.this.getDeltaMovement().scale(0.35));
            }
            if (absDy <= 0.1 && OtterEntity.this.isReadyToFloat()) {
                OtterEntity.this.setDeltaMovement(OtterEntity.this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                OtterEntity.this.setYya(0.0f);
                OtterEntity.this.setSpeed(0.0f);
                OtterEntity.this.startFloating(OtterEntity.this.getRandom().nextInt(80, 201));
                this.stop();
                return;
            }
            double dist = dx * dx + dy * dy + dz * dz;
            this.stuckTicks = dist > this.lastDist - 1.0E-4 ? ++this.stuckTicks : 0;
            this.lastDist = dist;
            if (navDone && dist > 2.25 || this.stuckTicks > 20) {
                if (OtterEntity.this.isReadyToFloat()) {
                    OtterEntity.this.startFloating(OtterEntity.this.getRandom().nextInt(80, 201));
                    this.stop();
                    return;
                }
                this.searchTargetPos();
                this.tickTimeout();
                this.stuckTicks = 0;
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        private void tickTimeout() {
            if (this.timeoutTimer % 2 == 0) {
                ((ServerLevel)OtterEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.BUBBLE, OtterEntity.this.getRandomX(0.6), OtterEntity.this.getY(), OtterEntity.this.getRandomZ(0.6), 2, 0.0, 0.1, 0.0, 0.0);
            }
            if (this.timeoutTimer <= 0) {
                OtterEntity.this.playSound((SoundEvent)CACSounds.OTTER_AMBIENT.get(), OtterEntity.this.getSoundVolume(), 0.3f);
                OtterEntity.this.rejectFood();
                this.stop();
                return;
            }
            --this.timeoutTimer;
        }

        public void stop() {
            OtterEntity.this.setNeedsSurface(false);
            OtterEntity.this.getNavigation().stop();
            this.timeoutTimer = this.timeoutTime;
            this.targetPos = null;
            this.stuckTicks = 0;
            this.lastDist = Double.MAX_VALUE;
        }

        private Vec3 findAirPosition() {
            Iterable blocksInRadius = BlockPos.betweenClosed((int)Mth.floor((double)(OtterEntity.this.getX() - 1.0)), (int)Mth.floor((float)OtterEntity.this.getBlockY()), (int)Mth.floor((double)(OtterEntity.this.getZ() - 1.0)), (int)Mth.floor((double)(OtterEntity.this.getX() + 1.0)), (int)Mth.floor((double)(OtterEntity.this.getY() + 32.0)), (int)Mth.floor((double)(OtterEntity.this.getZ() + 1.0)));
            for (BlockPos pos : blocksInRadius) {
                if (!OtterEntity.this.level().getBlockState(pos).isAir()) continue;
                return Vec3.atBottomCenterOf((Vec3i)pos);
            }
            return null;
        }
    }

    static class BreedGoal
    extends net.minecraft.world.entity.ai.goal.BreedGoal {
        private final OtterEntity otter;

        public BreedGoal(OtterEntity otterEntity) {
            super((Animal)otterEntity, 1.0);
            this.otter = otterEntity;
        }

        public boolean canUse() {
            return super.canUse() && !this.otter.isEating();
        }
    }

    public class SearchFoodGoal
    extends Goal {
        public SearchFoodGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!OtterEntity.this.getMainHandItem().isEmpty()) {
                return false;
            }
            List itemsInRadius = OtterEntity.this.level().getEntitiesOfClass(ItemEntity.class, OtterEntity.this.getBoundingBox().inflate(8.0, 8.0, 8.0), itemEntity -> OtterEntity.this.wantsToPickUp(itemEntity.getItem()) && !OtterEntity.this.rejectedItem((ItemEntity)itemEntity));
            return !itemsInRadius.isEmpty();
        }

        public void tick() {
            List itemsInRadius = OtterEntity.this.level().getEntitiesOfClass(ItemEntity.class, OtterEntity.this.getBoundingBox().inflate(8.0, 8.0, 8.0), itemEntity -> OtterEntity.this.wantsToPickUp(itemEntity.getItem()) && !OtterEntity.this.rejectedItem((ItemEntity)itemEntity));
            ItemStack handStack = OtterEntity.this.getMainHandItem();
            if (handStack.isEmpty() && !itemsInRadius.isEmpty()) {
                Path path = OtterEntity.this.getNavigation().createPath((Entity)itemsInRadius.get(0), 0);
                OtterEntity.this.getNavigation().moveTo(path, 1.0);
            }
        }

        public void start() {
            List itemsInRadius = OtterEntity.this.level().getEntitiesOfClass(ItemEntity.class, OtterEntity.this.getBoundingBox().inflate(8.0, 8.0, 8.0), itemEntity -> OtterEntity.this.wantsToPickUp(itemEntity.getItem()) && !OtterEntity.this.rejectedItem((ItemEntity)itemEntity));
            if (!itemsInRadius.isEmpty()) {
                Path path = OtterEntity.this.getNavigation().createPath((Entity)itemsInRadius.get(0), 0);
                OtterEntity.this.getNavigation().moveTo(path, 1.0);
            }
        }
    }

    static class FollowParentGoal
    extends net.minecraft.world.entity.ai.goal.FollowParentGoal {
        private final OtterEntity otter;

        public FollowParentGoal(OtterEntity otterEntity) {
            super((Animal)otterEntity, 1.2);
            this.otter = otterEntity;
        }

        public boolean canUse() {
            return !this.otter.isEating() && super.canUse();
        }
    }

    static class RandomStrollGoal
    extends net.minecraft.world.entity.ai.goal.RandomStrollGoal {
        private final OtterEntity otter;

        public RandomStrollGoal(OtterEntity otterEntity) {
            super((PathfinderMob)otterEntity, 1.0, 20);
            this.otter = otterEntity;
        }

        public boolean canUse() {
            return super.canUse() && !this.otter.isFloating() && !this.otter.needsSurface() && !this.otter.isEating();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && !this.otter.isFloating() && !this.otter.needsSurface() && !this.otter.isEating();
        }
    }

    static class LookAtPlayerGoal
    extends net.minecraft.world.entity.ai.goal.LookAtPlayerGoal {
        private final OtterEntity otter;

        public LookAtPlayerGoal(OtterEntity otterEntity) {
            super((Mob)otterEntity, Player.class, 8.0f);
            this.otter = otterEntity;
        }

        public boolean canUse() {
            return super.canUse() && !this.otter.isInWater() && !this.otter.isEating();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && !this.otter.isInWater() && !this.otter.isEating();
        }
    }

    static class RandomLookAroundGoal
    extends net.minecraft.world.entity.ai.goal.RandomLookAroundGoal {
        private final OtterEntity otter;

        public RandomLookAroundGoal(OtterEntity otterEntity) {
            super((Mob)otterEntity);
            this.otter = otterEntity;
        }

        public boolean canUse() {
            return super.canUse() && !this.otter.isInWater() && !this.otter.isEating();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && !this.otter.isInWater() && !this.otter.isEating();
        }
    }
}

