/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_caelum.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.CrushRecipeProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ArsProviders {
    static String root = "ars_caelum";

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.recipes.add(this.builder().withReagent(Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND)).withPedestalItem(8, (ItemLike)Items.NAUTILUS_SHELL).withResult((ItemLike)Items.HEART_OF_THE_SEA).withSourceCost(10000).build());
            this.recipes.add(this.builder().withPedestalItem(3, (ItemLike)Items.SCULK_SENSOR).buildEnchantmentRecipe(Enchantments.SWIFT_SNEAK, 1, 3000));
            this.recipes.add(this.builder().withPedestalItem(3, (ItemLike)Items.SCULK_SHRIEKER).buildEnchantmentRecipe(Enchantments.SWIFT_SNEAK, 2, 6000));
            this.recipes.add(this.builder().withPedestalItem(3, (ItemLike)Items.SCULK_CATALYST).buildEnchantmentRecipe(Enchantments.SWIFT_SNEAK, 3, 9000));
            for (ApparatusRecipeBuilder.RecipeWrapper wrapper : this.recipes) {
                Path path = EnchantingAppProvider.getRecipePath(this.output, wrapper.id().getPath());
                this.saveStable(cache, wrapper.serialize(), path);
            }
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        public String getName() {
            return "Example Apparatus";
        }
    }

    public static class CrushProvider
    extends CrushRecipeProvider {
        public DataGenerator generator;
        public List<CrushWrapper> replaceAn = new ArrayList<CrushWrapper>();

        public CrushProvider(DataGenerator generatorIn) {
            super(generatorIn);
            this.generator = generatorIn;
        }

        public void collectJsons(CachedOutput cache) {
            CrushRecipe.CrushOutput goldNug = new CrushRecipe.CrushOutput(Items.GOLD_NUGGET.getDefaultInstance(), 0.2f, 3);
            CrushRecipe.CrushOutput ironNug = new CrushRecipe.CrushOutput(Items.IRON_NUGGET.getDefaultInstance(), 0.2f, 3);
            CrushRecipe.CrushOutput copperNug = new CrushRecipe.CrushOutput(Items.RAW_COPPER.getDefaultInstance(), 0.2f, 1);
            this.replaceAn.add(new CrushWrapper("stone", Ingredient.of((TagKey)Tags.Items.STONES)).withItems(Items.GRAVEL.getDefaultInstance()).withItems(goldNug).withItems(ironNug).withItems(copperNug));
            this.replaceAn.add(new CrushWrapper("cobblestone", Ingredient.of((TagKey)Tags.Items.COBBLESTONES)).withItems(Items.GRAVEL.getDefaultInstance()).withItems(goldNug).withItems(ironNug).withItems(copperNug));
            this.replaceAn.add(new CrushWrapper("gravel", Ingredient.of((TagKey)Tags.Items.GRAVELS)).withItems(Items.SAND.getDefaultInstance()).withItems(Items.LAPIS_LAZULI.getDefaultInstance(), 0.05f).withItems(Items.DIAMOND.getDefaultInstance(), 0.01f).withItems(Items.FLINT.getDefaultInstance(), 0.02f));
            this.replaceAn.add(new CrushWrapper("sand", Ingredient.of((TagKey)Tags.Items.SANDS)).withItems(Items.CLAY_BALL.getDefaultInstance(), 0.05f).withItems(Items.REDSTONE.getDefaultInstance(), 0.05f).skipBlockPlace());
            for (CrushWrapper g : this.replaceAn) {
                Path path = CrushProvider.getANPath(this.output, g.path.getPath());
                this.saveStable(cache, (JsonElement)CrushRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.asRecipe()).getOrThrow(), path);
            }
        }

        private static Path getANPath(Path pathIn, String str) {
            return pathIn.resolve("data/ars_nouveau/recipe/" + str + ".json");
        }

        public static class CrushWrapper {
            public ResourceLocation path;
            public Ingredient ing;
            private boolean shouldSkipBlockPlace = false;
            List<CrushRecipe.CrushOutput> outputs = new ArrayList<CrushRecipe.CrushOutput>();

            public CrushWrapper(String string, Ingredient ingredient) {
                this.path = ArsNouveau.prefix((String)string);
                this.ing = ingredient;
            }

            public CrushWrapper withItems(ItemStack output, float chance) {
                this.outputs.add(new CrushRecipe.CrushOutput(output, chance));
                return this;
            }

            public CrushWrapper withItems(ItemStack output) {
                this.outputs.add(new CrushRecipe.CrushOutput(output, 1.0f));
                return this;
            }

            public CrushWrapper withItems(CrushRecipe.CrushOutput output) {
                this.outputs.add(output);
                return this;
            }

            public CrushWrapper skipBlockPlace() {
                this.shouldSkipBlockPlace = true;
                return this;
            }

            public CrushRecipe asRecipe() {
                return new CrushRecipe(this.ing, this.outputs, this.shouldSkipBlockPlace);
            }
        }
    }
}

