/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_caelum.datagen;

import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelGen
extends ItemModelProvider {
    public ItemModelGen(PackOutput pack, String modid, ExistingFileHelper existingFileHelper) {
        super(pack, modid, existingFileHelper);
    }

    protected void registerModels() {
        for (RitualTablet i : RitualRegistry.getRitualItemMap().values()) {
            if (!i.ritual.getRegistryName().getNamespace().equals("ars_caelum")) continue;
            try {
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(i.ritual.getRegistryName().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture((Item)i));
            }
            catch (Exception e) {
                System.out.println("No texture for " + String.valueOf(i));
            }
        }
    }

    private ResourceLocation itemTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("item/" + name.getPath()));
    }

    private ResourceLocation registryName(Item item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)RegistryHelper.getRegistryName((Item)item), (String)"Item %s has a null registry name", (Object)item);
    }

    private ResourceLocation registryName(Block item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)RegistryHelper.getRegistryName((Block)item), (String)"Item %s has a null registry name", (Object)item);
    }

    private ResourceLocation itemTexture(Block item) {
        ResourceLocation name = this.registryName(item);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("items/" + name.getPath()));
    }

    private ResourceLocation spellTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("items/" + name.getPath().replace("glyph_", "")));
    }
}

