/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.cache;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaDynamicOps;
import dev.lukebemish.dynamicassetgenerator.api.cache.DataConsumer;
import java.util.List;

public class CacheMetaCodec<A>
implements Codec<A> {
    private final Codec<A> wrapped;
    private final List<SingleCacheType<?, A>> dataConsumers;

    private CacheMetaCodec(Codec<A> wrapped, List<SingleCacheType<?, A>> dataConsumers) {
        this.wrapped = wrapped;
        this.dataConsumers = dataConsumers;
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        return this.wrapped.decode(ops, input);
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        DataResult result = this.wrapped.encode(input, ops, prefix);
        if (ops instanceof CacheMetaDynamicOps) {
            CacheMetaDynamicOps cacheOps = (CacheMetaDynamicOps)ops;
            for (SingleCacheType<?, A> dataConsumer : this.dataConsumers) {
                result = dataConsumer.encode(input, cacheOps, result);
            }
        }
        return result;
    }

    public static <A> Codec<A> of(Codec<A> wrapped, List<SingleCacheType<?, A>> dataConsumers) {
        return new CacheMetaCodec<A>(wrapped, dataConsumers);
    }

    public static final class SingleCacheType<D, A> {
        private final DataConsumer<D, A> dataConsumer;
        private final String cacheKey;
        private final Class<? super D> dataClass;

        private SingleCacheType(DataConsumer<D, A> dataConsumer, String cacheKey, Class<? super D> dataClass) {
            this.dataConsumer = dataConsumer;
            this.cacheKey = cacheKey;
            this.dataClass = dataClass;
        }

        public static <D, A> SingleCacheType<D, A> of(DataConsumer<D, A> dataConsumer, String cacheKey, Class<? super D> dataClass) {
            return new SingleCacheType<D, A>(dataConsumer, cacheKey, dataClass);
        }

        public <T> DataResult<T> encode(A input, CacheMetaDynamicOps<T> ops, DataResult<T> result) {
            D opsData = ops.getData(this.dataClass);
            if (opsData != null) {
                DataResult metadata = this.dataConsumer.encode(ops, opsData, input);
                if (metadata.result().isEmpty()) {
                    return metadata;
                }
                return result.flatMap(t -> {
                    if (ops.getMap(t).result().isPresent()) {
                        return ops.mergeToMap(t, ops.createString(this.cacheKey), metadata.result().get());
                    }
                    RecordBuilder builder = ops.mapBuilder();
                    builder.add(ops.createString(this.cacheKey), metadata.result().get());
                    builder.add("value", t);
                    return builder.build(ops.empty());
                });
            }
            return result;
        }
    }
}

