/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.VillagerMetaDataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TextureMetaGenerator
implements ResourceGenerator {
    public static final MapCodec<TextureMetaGenerator> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)AnimationGenerator.CODEC.optionalFieldOf("animation", (Object)new AnimationGenerator.Builder().build()).forGetter(TextureMetaGenerator::getAnimation), (App)VillagerGenerator.CODEC.optionalFieldOf("villager", (Object)new VillagerGenerator.Builder().build()).forGetter(TextureMetaGenerator::getVillager), (App)TextureGenerator.CODEC.optionalFieldOf("texture", (Object)new TextureGenerator.Builder().build()).forGetter(TextureMetaGenerator::getTexture), (App)ResourceLocation.CODEC.fieldOf("output_location").forGetter(TextureMetaGenerator::getOutputLocation), (App)ResourceLocation.CODEC.listOf().fieldOf("sources").forGetter(TextureMetaGenerator::getSources)).apply((Applicative)i, TextureMetaGenerator::new));
    private final AnimationGenerator animation;
    private final VillagerGenerator villager;
    private final TextureGenerator texture;
    private final ResourceLocation outputLocation;
    private final List<ResourceLocation> sources;
    private static final Map<String, Function<TextureMetaGenerator, MetaSection>> SECTIONS = ImmutableMap.builder().put((Object)"animation", TextureMetaGenerator::getAnimation).put((Object)"villager", TextureMetaGenerator::getVillager).put((Object)"texture", TextureMetaGenerator::getTexture).build();

    private TextureMetaGenerator(AnimationGenerator animation, VillagerGenerator villager, TextureGenerator texture, ResourceLocation outputLocation, List<ResourceLocation> sources) {
        this.animation = animation;
        this.villager = villager;
        this.texture = texture;
        this.outputLocation = outputLocation;
        this.sources = sources;
    }

    public AnimationGenerator getAnimation() {
        return this.animation;
    }

    public VillagerGenerator getVillager() {
        return this.villager;
    }

    public TextureGenerator getTexture() {
        return this.texture;
    }

    public ResourceLocation getOutputLocation() {
        return this.outputLocation;
    }

    public List<ResourceLocation> getSources() {
        return this.sources;
    }

    @Override
    public <T> @NonNull DataResult<T> persistentCacheData(DynamicOps<T> ops, ResourceLocation location, ResourceGenerationContext context) {
        ListBuilder builder = ops.listBuilder();
        for (ResourceLocation s : this.sources) {
            ResourceLocation metaLocation = ResourceLocation.fromNamespaceAndPath((String)s.getNamespace(), (String)("textures/" + s.getPath() + ".png.mcmeta"));
            IoSupplier<InputStream> supplier = context.getResourceSource().getResource(metaLocation);
            if (supplier == null) {
                builder.add(ops.empty());
                continue;
            }
            try {
                InputStream is = (InputStream)supplier.get();
                try {
                    byte[] bytes = is.readAllBytes();
                    String string = Base64.getEncoder().encodeToString(bytes);
                    builder.add(ops.createString(string));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException ignored) {
                return DataResult.error(() -> "Cannot cache potentially erroring source");
            }
        }
        return builder.build(ops.empty());
    }

    @Override
    public @Nullable IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        if (this.sources.isEmpty()) {
            DynamicAssetGenerator.LOGGER.error("No sources provided for texture metadata at {}: ", (Object)this.outputLocation);
            return null;
        }
        return () -> {
            List<Pair> originals = this.sources.stream().map(s -> {
                Pair pair;
                ResourceLocation metaLocation = ResourceLocation.fromNamespaceAndPath((String)s.getNamespace(), (String)("textures/" + s.getPath() + ".png.mcmeta"));
                IoSupplier<InputStream> resource = context.getResourceSource().getResource(metaLocation);
                if (resource == null) {
                    return Pair.of((Object)s, null);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)resource.get()));
                try {
                    JsonObject meta = (JsonObject)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonObject.class);
                    pair = Pair.of((Object)s, (Object)meta);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return Pair.of((Object)s, null);
                    }
                }
                reader.close();
                return pair;
            }).toList();
            JsonObject out = new JsonObject();
            for (Map.Entry<String, Function<TextureMetaGenerator, MetaSection>> entry : SECTIONS.entrySet()) {
                MetaSection section = entry.getValue().apply(this);
                JsonObject member = section.apply(originals.stream().map(p -> {
                    JsonObject object = (JsonObject)p.getSecond();
                    if (object == null) {
                        return new Pair((Object)((ResourceLocation)p.getFirst()), null);
                    }
                    JsonElement objectEntry = object.get((String)entry.getKey());
                    if (objectEntry == null || !objectEntry.isJsonObject()) {
                        return new Pair((Object)((ResourceLocation)p.getFirst()), null);
                    }
                    return new Pair((Object)((ResourceLocation)p.getFirst()), (Object)objectEntry.getAsJsonObject());
                }).toList());
                if (member == null) continue;
                out.add(entry.getKey(), (JsonElement)member);
            }
            return new ByteArrayInputStream(DynamicAssetGenerator.GSON_FLAT.toJson((JsonElement)out).getBytes(StandardCharsets.UTF_8));
        };
    }

    @Override
    public @NonNull Set<ResourceLocation> getLocations(ResourceGenerationContext context) {
        return Set.of(ResourceLocation.fromNamespaceAndPath((String)this.outputLocation.getNamespace(), (String)("textures/" + this.outputLocation.getPath() + ".png.mcmeta")));
    }

    @Override
    public MapCodec<? extends ResourceGenerator> codec() {
        return CODEC;
    }

    private static void tryForEach(List<Pair<ResourceLocation, JsonObject>> originals, String key, Predicate<JsonElement> filter, Predicate<JsonElement> consumer) {
        for (Pair<ResourceLocation, JsonObject> original : originals) {
            JsonElement member;
            if (original.getSecond() == null || (member = ((JsonObject)original.getSecond()).get(key)) == null || !filter.test(member) || !consumer.test(member)) continue;
            return;
        }
    }

    private static boolean areAllMissing(List<Pair<ResourceLocation, JsonObject>> originals) {
        for (Pair<ResourceLocation, JsonObject> original : originals) {
            if (original.getSecond() == null) continue;
            return false;
        }
        return true;
    }

    public static class AnimationGenerator
    implements MetaSection {
        public static final Codec<AnimationGenerator> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("frametime").forGetter(AnimationGenerator::getFrametime), (App)Codec.INT.optionalFieldOf("width").forGetter(AnimationGenerator::getWidth), (App)Codec.INT.optionalFieldOf("height").forGetter(AnimationGenerator::getHeight), (App)Codec.BOOL.optionalFieldOf("interpolate").forGetter(AnimationGenerator::getInterpolate)).apply((Applicative)i, AnimationGenerator::new));
        private final Optional<Integer> frametime;
        private final Optional<Integer> width;
        private final Optional<Integer> height;
        private final Optional<Boolean> interpolate;

        private AnimationGenerator(Optional<Integer> frametime, Optional<Integer> width, Optional<Integer> height, Optional<Boolean> interpolate) {
            this.frametime = frametime;
            this.width = width;
            this.height = height;
            this.interpolate = interpolate;
        }

        public Optional<Integer> getFrametime() {
            return this.frametime;
        }

        public Optional<Integer> getWidth() {
            return this.width;
        }

        public Optional<Integer> getHeight() {
            return this.height;
        }

        public Optional<Boolean> getInterpolate() {
            return this.interpolate;
        }

        @Override
        public @Nullable JsonObject apply(List<Pair<ResourceLocation, JsonObject>> originals) {
            int frametime;
            if (TextureMetaGenerator.areAllMissing(originals) && this.frametime.isEmpty() && this.width.isEmpty() && this.height.isEmpty() && this.interpolate.isEmpty()) {
                return null;
            }
            List<ResourceLocation> originalsLocations = originals.stream().map(Pair::getFirst).toList();
            Map<ResourceLocation, AnimationMetadataSection> parsed = originals.stream().map(p -> {
                JsonObject object = (JsonObject)p.getSecond();
                if (object == null) {
                    return null;
                }
                try {
                    return new Pair((Object)((ResourceLocation)p.getFirst()), (Object)AnimationMetadataSection.SERIALIZER.fromJson(object));
                }
                catch (Exception ignored) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            JsonObject out = new JsonObject();
            this.frametime.ifPresentOrElse(i -> out.addProperty("frametime", (Number)i), () -> TextureMetaGenerator.tryForEach(originals, "frametime", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("frametime", (Number)member.getAsInt());
                    return true;
                }
                catch (NumberFormatException | UnsupportedOperationException runtimeException) {
                    return false;
                }
            }));
            this.width.ifPresentOrElse(i -> out.addProperty("width", (Number)i), () -> TextureMetaGenerator.tryForEach(originals, "width", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("width", (Number)member.getAsInt());
                    return true;
                }
                catch (NumberFormatException | UnsupportedOperationException runtimeException) {
                    return false;
                }
            }));
            this.height.ifPresentOrElse(i -> out.addProperty("height", (Number)i), () -> TextureMetaGenerator.tryForEach(originals, "height", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("height", (Number)member.getAsInt());
                    return true;
                }
                catch (NumberFormatException | UnsupportedOperationException runtimeException) {
                    return false;
                }
            }));
            this.interpolate.ifPresentOrElse(i -> out.addProperty("interpolate", i), () -> TextureMetaGenerator.tryForEach(originals, "interpolate", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("interpolate", Boolean.valueOf(member.getAsBoolean()));
                    return true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
            }));
            List<Frame> frames = new ArrayList<Frame>();
            try {
                frametime = out.getAsJsonPrimitive("frametime").getAsInt();
            }
            catch (Exception ignored) {
                frametime = 1;
            }
            frames.add(new Frame(0, frametime));
            for (ResourceLocation location : originalsLocations) {
                AnimationMetadataSection section = parsed.get(location);
                if (section == null) continue;
                int maxFrames = AnimationGenerator.getMaxFrames(section);
                frames = AnimationGenerator.mutateList(frames, section, maxFrames);
            }
            if (frames.size() > 1) {
                JsonArray framesOut = new JsonArray();
                out.add("frames", (JsonElement)framesOut);
                for (Frame frame : frames) {
                    JsonObject frameOut = new JsonObject();
                    frameOut.addProperty("index", (Number)frame.index());
                    frameOut.addProperty("time", (Number)frame.time());
                    framesOut.add((JsonElement)frameOut);
                }
            }
            return out;
        }

        private static int getMaxFrames(AnimationMetadataSection section) {
            AtomicInteger maxFrames = new AtomicInteger(0);
            section.forEachFrame((index, time) -> maxFrames.set(Math.max(maxFrames.get(), index)));
            return maxFrames.get() + 1;
        }

        private static List<Frame> mutateList(List<Frame> pattern, AnimationMetadataSection section, int maxFrames) {
            ArrayList<Frame> out = new ArrayList<Frame>();
            for (Frame frame : pattern) {
                section.forEachFrame((index, time) -> {
                    int frameTime = time * frame.time / section.getDefaultFrameTime();
                    out.add(new Frame(frame.index * maxFrames + index, frameTime));
                });
            }
            return out;
        }

        private record Frame(int index, int time) {
        }

        public static class Builder {
            private Optional<Integer> frametime = Optional.empty();
            private Optional<Integer> width = Optional.empty();
            private Optional<Integer> height = Optional.empty();
            private Optional<Boolean> interpolate = Optional.empty();

            public Builder setFrametime(int frametime) {
                this.frametime = Optional.of(frametime);
                return this;
            }

            public Builder setWidth(int width) {
                this.width = Optional.of(width);
                return this;
            }

            public Builder setHeight(int height) {
                this.height = Optional.of(height);
                return this;
            }

            public Builder setInterpolate(boolean interpolate) {
                this.interpolate = Optional.of(interpolate);
                return this;
            }

            public AnimationGenerator build() {
                return new AnimationGenerator(this.frametime, this.width, this.height, this.interpolate);
            }
        }
    }

    public static class VillagerGenerator
    implements MetaSection {
        public static final Codec<VillagerMetaDataSection.Hat> HAT_CODEC = Codec.STRING.flatXmap(s -> switch (s) {
            case "none" -> DataResult.success((Object)VillagerMetaDataSection.Hat.NONE);
            case "partial" -> DataResult.success((Object)VillagerMetaDataSection.Hat.PARTIAL);
            case "full" -> DataResult.success((Object)VillagerMetaDataSection.Hat.FULL);
            default -> DataResult.error(() -> "Unknown hat type: " + s);
        }, h -> DataResult.success((Object)VillagerGenerator.getHatName(h)));
        public static final Codec<VillagerGenerator> CODEC = RecordCodecBuilder.create(i -> i.group((App)HAT_CODEC.optionalFieldOf("hat").forGetter(VillagerGenerator::getHat)).apply((Applicative)i, VillagerGenerator::new));
        private final Optional<VillagerMetaDataSection.Hat> hat;

        private static String getHatName(VillagerMetaDataSection.Hat hat) {
            return switch (hat) {
                default -> throw new MatchException(null, null);
                case VillagerMetaDataSection.Hat.NONE -> "none";
                case VillagerMetaDataSection.Hat.PARTIAL -> "partial";
                case VillagerMetaDataSection.Hat.FULL -> "full";
            };
        }

        private VillagerGenerator(Optional<VillagerMetaDataSection.Hat> hat) {
            this.hat = hat;
        }

        public Optional<VillagerMetaDataSection.Hat> getHat() {
            return this.hat;
        }

        @Override
        public @Nullable JsonObject apply(List<Pair<ResourceLocation, JsonObject>> originals) {
            if (TextureMetaGenerator.areAllMissing(originals) && this.hat.isEmpty()) {
                return null;
            }
            JsonObject out = new JsonObject();
            this.hat.ifPresentOrElse(h -> out.addProperty("hat", VillagerGenerator.getHatName(h)), () -> TextureMetaGenerator.tryForEach(originals, "hat", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("hat", member.getAsString());
                    return true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
            }));
            return out;
        }

        public static class Builder {
            private Optional<VillagerMetaDataSection.Hat> hat = Optional.empty();

            public Builder setHat(VillagerMetaDataSection.Hat hat) {
                this.hat = Optional.of(hat);
                return this;
            }

            public VillagerGenerator build() {
                return new VillagerGenerator(this.hat);
            }
        }
    }

    public static class TextureGenerator
    implements MetaSection {
        public static final Codec<TextureGenerator> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.optionalFieldOf("blur").forGetter(TextureGenerator::getBlur), (App)Codec.BOOL.optionalFieldOf("clamp").forGetter(TextureGenerator::getClamp)).apply((Applicative)i, TextureGenerator::new));
        private final Optional<Boolean> blur;
        private final Optional<Boolean> clamp;

        private TextureGenerator(Optional<Boolean> blur, Optional<Boolean> clamp) {
            this.blur = blur;
            this.clamp = clamp;
        }

        public Optional<Boolean> getBlur() {
            return this.blur;
        }

        public Optional<Boolean> getClamp() {
            return this.clamp;
        }

        @Override
        public @Nullable JsonObject apply(List<Pair<ResourceLocation, JsonObject>> originals) {
            if (TextureMetaGenerator.areAllMissing(originals) && this.blur.isEmpty() && this.clamp.isEmpty()) {
                return null;
            }
            JsonObject out = new JsonObject();
            this.blur.ifPresentOrElse(b -> out.addProperty("blur", b), () -> TextureMetaGenerator.tryForEach(originals, "blur", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("blur", Boolean.valueOf(member.getAsBoolean()));
                    return true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
            }));
            this.clamp.ifPresentOrElse(b -> out.addProperty("clamp", b), () -> TextureMetaGenerator.tryForEach(originals, "clamp", JsonElement::isJsonPrimitive, member -> {
                try {
                    out.addProperty("clamp", Boolean.valueOf(member.getAsBoolean()));
                    return true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
            }));
            return out;
        }

        public static class Builder {
            private Optional<Boolean> blur = Optional.empty();
            private Optional<Boolean> clamp = Optional.empty();

            public Builder setBlur(boolean blur) {
                this.blur = Optional.of(blur);
                return this;
            }

            public Builder setClamp(boolean clamp) {
                this.clamp = Optional.of(clamp);
                return this;
            }

            public TextureGenerator build() {
                return new TextureGenerator(this.blur, this.clamp);
            }
        }
    }

    public static interface MetaSection {
        public @Nullable JsonObject apply(List<Pair<ResourceLocation, JsonObject>> var1);
    }

    public static class Builder {
        private AnimationGenerator animation = new AnimationGenerator.Builder().build();
        private VillagerGenerator villager = new VillagerGenerator.Builder().build();
        private TextureGenerator texture = new TextureGenerator.Builder().build();
        private ResourceLocation outputLocation;
        private List<ResourceLocation> sources;

        public Builder setAnimation(AnimationGenerator animation) {
            this.animation = animation;
            return this;
        }

        public Builder setVillager(VillagerGenerator villager) {
            this.villager = villager;
            return this;
        }

        public Builder setTexture(TextureGenerator texture) {
            this.texture = texture;
            return this;
        }

        public Builder setOutputLocation(ResourceLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public Builder setSources(List<ResourceLocation> sources) {
            this.sources = sources;
            return this;
        }

        public TextureMetaGenerator build() {
            Objects.requireNonNull(this.outputLocation);
            Objects.requireNonNull(this.sources);
            return new TextureMetaGenerator(this.animation, this.villager, this.texture, this.outputLocation, this.sources);
        }
    }
}

