/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.AnimationSplittingSource;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;

public final class AnimationFrameCapture
implements TexSource {
    public static final MapCodec<AnimationFrameCapture> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("capture").forGetter(AnimationFrameCapture::getCapture)).apply((Applicative)instance, AnimationFrameCapture::new));
    private final String capture;

    private AnimationFrameCapture(String capture) {
        this.capture = capture;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        return () -> {
            AnimationSplittingSource.ImageCollection collection = data.get(AnimationSplittingSource.IMAGE_COLLECTION_TOKEN);
            if (collection == null) {
                data.getLogger().debug("No parent animation source to capture...");
                throw new IOException("No parent animation source to capture...");
            }
            NativeImage image = collection.get(this.getCapture());
            if (image == null) {
                data.getLogger().debug("Key '{}' was not supplied to capture...", (Object)this.getCapture());
                throw new IOException("Key '" + this.getCapture() + "' was not supplied to capture...");
            }
            return image;
        };
    }

    @Override
    public <T> @NonNull DataResult<T> cacheMetadata(DynamicOps<T> ops, TexSourceDataHolder data) {
        AnimationSplittingSource.ImageCollection collection = data.get(AnimationSplittingSource.IMAGE_COLLECTION_TOKEN);
        if (collection != null) {
            RecordBuilder builder = ops.mapBuilder();
            builder.add("frame", ops.createInt(collection.getFrame()));
            TexSource source = collection.getFull(this.getCapture());
            if (source == null) {
                return DataResult.error(() -> "In uncacheable state, no parent animation source to capture...");
            }
            DataResult parentElementTyped = TexSource.CODEC.encodeStart(ops, (Object)source);
            if (parentElementTyped.error().isPresent()) {
                return DataResult.error(() -> "Could not encode parent animation source: " + ((DataResult.Error)parentElementTyped.error().get()).message());
            }
            builder.add("parent", parentElementTyped);
            return builder.build(ops.empty());
        }
        return TexSource.super.cacheMetadata(ops, data);
    }

    public String getCapture() {
        return this.capture;
    }

    public static class Builder {
        private String capture;

        public Builder setCapture(String capture) {
            this.capture = capture;
            return this;
        }

        public AnimationFrameCapture build() {
            Objects.requireNonNull(this.capture);
            return new AnimationFrameCapture(this.capture);
        }
    }
}

