/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import dev.lukebemish.dynamicassetgenerator.impl.util.Maath;
import dev.lukebemish.dynamicassetgenerator.impl.util.MultiCloser;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AnimationSplittingSource
implements TexSource {
    public static final MapCodec<AnimationSplittingSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TexSource.CODEC).fieldOf("sources").forGetter(AnimationSplittingSource::getSources), (App)TexSource.CODEC.fieldOf("generator").forGetter(AnimationSplittingSource::getGenerator)).apply((Applicative)instance, AnimationSplittingSource::new));
    private final Map<String, TexSource> sources;
    private final TexSource generator;
    static final TexSourceDataHolder.Token<ImageCollection> IMAGE_COLLECTION_TOKEN = new TexSourceDataHolder.Token();

    private AnimationSplittingSource(Map<String, TexSource> sources, TexSource generator) {
        this.sources = sources;
        this.generator = generator;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        HashMap sourcesMap = new HashMap();
        this.getSources().forEach((key, source) -> sourcesMap.put(key, source.getCachedSupplier(data, context)));
        if (sourcesMap.isEmpty()) {
            data.getLogger().error("No sources given...");
            return null;
        }
        return () -> {
            HashMap<String, NativeImage> images = new HashMap<String, NativeImage>();
            for (Map.Entry e : sourcesMap.entrySet()) {
                String key = (String)e.getKey();
                images.put(key, (NativeImage)((IoSupplier)e.getValue()).get());
            }
            try (MultiCloser ignored = new MultiCloser(images.values());){
                List imageList = images.values().stream().toList();
                List<Integer> counts = images.values().stream().map(AnimationSplittingSource::getFrameCount).toList();
                for (int i : counts) {
                    if (i != 0) continue;
                    data.getLogger().error("Source not shaped correctly for an animation...");
                    throw new IOException("Source not shaped correctly for an animation...");
                }
                int lcm = Maath.lcm(counts);
                int lcmWidth = Maath.lcm(imageList.stream().map(NativeImage::getWidth).toList());
                NativeImage output = NativeImageHelper.of(NativeImage.Format.RGBA, lcmWidth, lcmWidth * lcm, false);
                for (int i = 0; i < lcm; ++i) {
                    HashMap<String, NativeImage> map = new HashMap<String, NativeImage>();
                    int finalI = i;
                    images.forEach((str, old) -> map.put((String)str, AnimationSplittingSource.getPartialImage(old, finalI)));
                    try (ImageCollection collection = new ImageCollection(map, this.getSources(), i);){
                        TexSourceDataHolder newData = new TexSourceDataHolder(data);
                        newData.put(IMAGE_COLLECTION_TOKEN, collection);
                        IoSupplier<NativeImage> supplier = this.generator.getCachedSupplier(newData, context);
                        if (supplier == null) {
                            data.getLogger().error("Generator created no image...");
                            throw new IOException("Generator created no image...");
                        }
                        NativeImage supplied = (NativeImage)supplier.get();
                        int sWidth = supplied.getWidth();
                        if (sWidth != supplied.getHeight()) {
                            data.getLogger().error("Generator created non-square image...\n{}", (Object)this.generator.stringify());
                            throw new IOException("Generator created non-square image...");
                        }
                        int scale = lcmWidth / sWidth;
                        for (int x = 0; x < lcmWidth; ++x) {
                            for (int y = 0; y < lcmWidth; ++y) {
                                int color = ImageUtils.safeGetPixelABGR(supplied, x / scale, y / scale);
                                output.setPixelRGBA(x, y + i * lcmWidth, color);
                            }
                        }
                        continue;
                    }
                }
                NativeImage nativeImage = output;
                return nativeImage;
            }
        };
    }

    private static int getFrameCount(NativeImage image) {
        return image.getHeight() / image.getWidth();
    }

    private static NativeImage getPartialImage(NativeImage input, int part) {
        int numFull = input.getHeight() / input.getWidth();
        int size = input.getWidth();
        NativeImage output = NativeImageHelper.of(input.format(), size, size, false);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                output.setPixelRGBA(x, y, ImageUtils.safeGetPixelABGR(input, x, part % numFull * size + y));
            }
        }
        return output;
    }

    public Map<String, TexSource> getSources() {
        return this.sources;
    }

    public TexSource getGenerator() {
        return this.generator;
    }

    @ApiStatus.Internal
    static class ImageCollection
    implements Closeable {
        private final Map<String, NativeImage> map;
        private final Map<String, TexSource> original;
        private final int frame;

        @ApiStatus.Internal
        private ImageCollection(Map<String, NativeImage> map, Map<String, TexSource> original, int frame) {
            this.map = new HashMap<String, NativeImage>(map);
            this.original = original;
            this.frame = frame;
        }

        @Override
        public void close() {
            this.map.values().forEach(NativeImage::close);
        }

        public NativeImage get(String key) throws IOException {
            NativeImage input = this.map.get(key);
            if (input == null) {
                throw new IOException("No image for key: " + key);
            }
            NativeImage newImage = new NativeImage(input.format(), input.getWidth(), input.getHeight(), false);
            newImage.copyFrom(input);
            return newImage;
        }

        public int getFrame() {
            return this.frame;
        }

        public TexSource getFull(String key) {
            return this.original.get(key);
        }
    }

    public static class Builder {
        private Map<String, TexSource> sources;
        private TexSource generator;

        public Builder setSources(Map<String, TexSource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder setGenerator(TexSource generator) {
            this.generator = generator;
            return this;
        }

        public AnimationSplittingSource build() {
            Objects.requireNonNull(this.sources);
            Objects.requireNonNull(this.generator);
            return new AnimationSplittingSource(this.sources, this.generator);
        }
    }
}

