/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorEncoding;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.StringRepresentable;
import org.jspecify.annotations.NonNull;

public final class ColorSource
implements TexSource {
    public static final ColorEncoding DEFAULT_COLOR_ENCODING = ColorEncoding.ARGB;
    public static final MapCodec<ColorSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.STRING, (Codec)Codec.INT).flatXmap(e -> (DataResult)e.map(s -> {
        try {
            return DataResult.success((Object)Integer.parseInt(s));
        }
        catch (NumberFormatException ex) {
            return DataResult.error(() -> "Not an integer: " + s);
        }
    }, DataResult::success), i -> DataResult.success((Object)Either.right((Object)i))).listOf().fieldOf("color").forGetter(s -> s.color), (App)StringRepresentable.fromEnum(ColorEncoding::values).optionalFieldOf("encoding", (Object)DEFAULT_COLOR_ENCODING).forGetter(ColorSource::getColorEncoding)).apply((Applicative)instance, ColorSource::new));
    private final List<Integer> color;
    private final ColorEncoding colorEncoding;

    private ColorSource(List<Integer> color, ColorEncoding colorEncoding) {
        this.color = color;
        this.colorEncoding = colorEncoding;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        return () -> {
            int len = this.color.size();
            int sideLength = 0;
            for (int i = 0; i < 8; ++i) {
                sideLength = (int)Math.pow(2.0, i);
                if (Math.pow(2.0, i) * Math.pow(2.0, i) >= (double)len) break;
            }
            NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, sideLength, sideLength, false);
            block1: for (int y = 0; y < sideLength; ++y) {
                for (int x = 0; x < sideLength; ++x) {
                    if (x + sideLength * y >= len) break block1;
                    int encodedColor = this.colorEncoding.toABGR.applyAsInt(this.color.get(x + sideLength * y));
                    out.setPixelRGBA(x, y, encodedColor);
                }
            }
            return out;
        };
    }

    public List<Integer> getColor() {
        return this.color;
    }

    public ColorEncoding getColorEncoding() {
        return this.colorEncoding;
    }

    public static class Builder {
        private List<Integer> color;
        private ColorEncoding colorEncoding = DEFAULT_COLOR_ENCODING;

        public Builder setColor(List<Integer> color) {
            this.color = color;
            return this;
        }

        public Builder setColorEncoding(ColorEncoding colorEncoding) {
            this.colorEncoding = colorEncoding;
            return this;
        }

        public ColorSource build() {
            Objects.requireNonNull(this.color);
            return new ColorSource(this.color, this.colorEncoding);
        }
    }
}

