/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.Channel;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ChannelMask
implements TexSource {
    public static final MapCodec<ChannelMask> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(ChannelMask::getSource), (App)Channel.CODEC.fieldOf("channel").forGetter(ChannelMask::getChannel)).apply((Applicative)i, ChannelMask::new));
    private final TexSource source;
    private final Channel channel;

    private ChannelMask(TexSource source, Channel channel) {
        this.source = source;
        this.channel = channel;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.source.getCachedSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source.stringify());
            return null;
        }
        return () -> {
            PointwiseOperation.Unary<Integer> operation = PointwiseOperation.Unary.chain(this.channel.makeOperation(), (c, i) -> (c & 0xFF) << 24 | 0xFFFFFF);
            try (NativeImage inImg = (NativeImage)input.get();){
                NativeImage nativeImage = ImageUtils.generateScaledImage(operation, List.of(inImg));
                return nativeImage;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public static class Builder {
        private TexSource source;
        private Channel channel;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setChannel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public ChannelMask build() {
            Objects.requireNonNull(this.source);
            Objects.requireNonNull(this.channel);
            return new ChannelMask(this.source, this.channel);
        }
    }
}

