/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.image;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import dev.lukebemish.dynamicassetgenerator.impl.util.Maath;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.util.TriConsumer;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static Palette getPalette(NativeImage image, double cutoff) {
        Palette palette = new Palette(cutoff);
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int color = ImageUtils.safeGetPixelARGB(image, i, j);
                if (ColorTypes.ARGB32.alpha(color) == 0) continue;
                palette.add(color);
            }
        }
        return palette;
    }

    public static Palette getPalette(NativeImage image) {
        return ImageUtils.getPalette(image, 3.5);
    }

    public static int safeGetPixelABGR(NativeImage image, int x, int y, int def) {
        if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return def;
        }
        return image.getPixelRGBA(x, y);
    }

    public static int safeGetPixelABGR(NativeImage image, int x, int y) {
        return ImageUtils.safeGetPixelABGR(image, x, y, 0);
    }

    public static boolean safeSetPixelABGR(NativeImage image, int x, int y, int color) {
        if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return false;
        }
        image.setPixelRGBA(x, y, color);
        return true;
    }

    public static int safeGetPixelARGB(NativeImage image, int x, int y, int def) {
        if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return def;
        }
        return ColorTypes.ABGR32.toARGB32(image.getPixelRGBA(x, y));
    }

    public static int safeGetPixelARGB(NativeImage image, int x, int y) {
        return ImageUtils.safeGetPixelARGB(image, x, y, 0);
    }

    public static boolean safeSetPixelARGB(NativeImage image, int x, int y, int color) {
        if (x < 0 || x >= image.getWidth() || y < 0 || y >= image.getHeight()) {
            return false;
        }
        image.setPixelRGBA(x, y, ColorTypes.ABGR32.fromARGB32(color));
        return true;
    }

    public static Pair<Integer, Integer> calculateScaledSize(List<NativeImage> images) {
        IntArrayList widths = new IntArrayList(images.size());
        IntArrayList heights = new IntArrayList(images.size());
        for (NativeImage image : images) {
            widths.add(image.getWidth());
            heights.add(image.getHeight());
        }
        int maxWidth = Maath.lcm((List<Integer>)widths);
        int maxHeight = 0;
        for (int i = 0; i < images.size(); ++i) {
            int scaledHeight = maxWidth / widths.getInt(i) * heights.getInt(i);
            if (scaledHeight <= maxHeight) continue;
            maxHeight = scaledHeight;
        }
        return Pair.of((Object)maxWidth, (Object)maxHeight);
    }

    public static <T> void applyScaledOperation(PointwiseOperation<T> pointwiseOperation, OperationResultConsumer<T> consumer, List<NativeImage> images) {
        if (pointwiseOperation.expectedImages() != images.size() && pointwiseOperation.expectedImages() != -1) {
            throw new IllegalArgumentException("Expected " + pointwiseOperation.expectedImages() + " images, got " + images.size());
        }
        Pair<Integer, Integer> scaledSize = ImageUtils.calculateScaledSize(images);
        int width = (Integer)scaledSize.getFirst();
        int height = (Integer)scaledSize.getSecond();
        int numImages = images.size();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int[] colors = new int[numImages];
                boolean[] inBounds = new boolean[numImages];
                for (int k = 0; k < numImages; ++k) {
                    int x = i * images.get(k).getWidth() / width;
                    int y = j * images.get(k).getHeight() / height;
                    colors[k] = ImageUtils.safeGetPixelARGB(images.get(k), x, y, 0);
                    inBounds[k] = x >= 0 && x < images.get(k).getWidth() && y >= 0 && y < images.get(k).getHeight();
                }
                T t = pointwiseOperation.apply(colors, inBounds);
                consumer.accept(i, j, t);
            }
        }
    }

    public static <T> void applyParallelScaledOperation(PointwiseOperation<T> pointwiseOperation, OperationResultConsumer<T> consumer, List<NativeImage> images) {
        if (pointwiseOperation.expectedImages() != images.size() && pointwiseOperation.expectedImages() != -1) {
            throw new IllegalArgumentException("Expected " + pointwiseOperation.expectedImages() + " images, got " + images.size());
        }
        Pair<Integer, Integer> scaledSize = ImageUtils.calculateScaledSize(images);
        int width = (Integer)scaledSize.getFirst();
        int height = (Integer)scaledSize.getSecond();
        int numImages = images.size();
        IntStream.range(0, width).parallel().forEach(i -> {
            for (int j = 0; j < height; ++j) {
                int[] colors = new int[numImages];
                boolean[] inBounds = new boolean[numImages];
                for (int k = 0; k < numImages; ++k) {
                    int x = i * ((NativeImage)images.get(k)).getWidth() / width;
                    int y = j * ((NativeImage)images.get(k)).getHeight() / height;
                    colors[k] = ImageUtils.safeGetPixelARGB((NativeImage)images.get(k), x, y, 0);
                    inBounds[k] = x >= 0 && x < ((NativeImage)images.get(k)).getWidth() && y >= 0 && y < ((NativeImage)images.get(k)).getHeight();
                }
                Object t = pointwiseOperation.apply(colors, inBounds);
                consumer.accept(i, j, t);
            }
        });
    }

    public static NativeImage generateScaledImage(PointwiseOperation<Integer> pointwiseOperation, List<NativeImage> images) {
        Pair<Integer, Integer> scaledSize = ImageUtils.calculateScaledSize(images);
        int width = (Integer)scaledSize.getFirst();
        int height = (Integer)scaledSize.getSecond();
        NativeImage out = new NativeImage(width, height, false);
        ImageUtils.applyParallelScaledOperation(pointwiseOperation, (x, y, color) -> ImageUtils.safeSetPixelARGB(out, x, y, color), images);
        return out;
    }

    @FunctionalInterface
    public static interface OperationResultConsumer<T>
    extends TriConsumer<Integer, Integer, T> {
        public void acceptResult(int var1, int var2, T var3);

        default public void accept(Integer integer, Integer integer2, T t) {
            this.acceptResult(integer, integer2, t);
        }
    }
}

