/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import com.mojang.serialization.Codec;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.StringRepresentable;
import org.jspecify.annotations.NonNull;

public enum ColorEncoding implements StringRepresentable
{
    ARGB("ARGB", ColorTypes.ABGR32::fromARGB32, ColorTypes.ABGR32::toARGB32),
    RGB("RGB", i -> ColorTypes.ABGR32.fromARGB32(i) | 0xFF000000, i -> ColorTypes.ABGR32.toARGB32(i) | 0xFF000000),
    ABGR("ABGR", IntUnaryOperator.identity(), IntUnaryOperator.identity()),
    BGR("BGR", i -> i | 0xFF000000, i -> i | 0xFF000000);

    public final IntUnaryOperator toABGR;
    public final IntUnaryOperator fromABGR;
    private final String name;
    public static final Codec<ColorEncoding> CODEC;

    private ColorEncoding(String name, IntUnaryOperator toABGR, IntUnaryOperator fromABGR) {
        this.name = name;
        this.toABGR = toABGR;
        this.fromABGR = fromABGR;
    }

    public @NonNull String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ColorEncoding::values);
    }
}

