/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public class FuzzySet<T>
implements Set<T> {
    private final Map<T, Set<T>> fuzzy = new HashMap<T, Set<T>>();
    private final BiPredicate<T, T> cutoff;
    private final Function<Collection<T>, T> averager;

    public FuzzySet(BiPredicate<T, T> cutoff, Function<Collection<T>, T> averager) {
        this.cutoff = cutoff;
        this.averager = averager;
    }

    @Override
    public int size() {
        return this.fuzzy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fuzzy.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        Object t = o;
        block0: for (T key : this.fuzzy.keySet()) {
            if (!this.cutoff.test(key, t)) continue;
            Set<T> set = this.fuzzy.get(key);
            if (set.size() != 1) {
                for (T e : set) {
                    if (this.cutoff.test(e, t)) continue;
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return this.fuzzy.keySet().iterator();
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.fuzzy.keySet().toArray();
    }

    @Override
    public <T1> T1 @NonNull [] toArray(T1 @NonNull [] t1s) {
        return this.fuzzy.keySet().toArray(t1s);
    }

    @Override
    public boolean add(T t) {
        block0: for (T key : this.fuzzy.keySet()) {
            if (!this.cutoff.test(key, t)) continue;
            Set<T> set = this.fuzzy.get(key);
            if (set.size() != 1) {
                for (T e : set) {
                    if (this.cutoff.test(e, t)) continue;
                    continue block0;
                }
            }
            if (set.contains(t)) {
                return false;
            }
            set.add(t);
            T newKey = this.averager.apply(set);
            this.fuzzy.remove(key);
            this.fuzzy.put(newKey, set);
            return false;
        }
        this.fuzzy.put(t, new HashSet());
        return true;
    }

    @Override
    public boolean remove(Object o) {
        for (T key : this.fuzzy.keySet()) {
            if (!this.cutoff.test(key, o)) continue;
            this.fuzzy.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> collection) {
        boolean changed = false;
        for (T t : collection) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        Iterator keys = this.fuzzy.keySet().stream().filter(ts -> {
            for (Object o : collection) {
                if (!this.cutoff.test(ts, o)) continue;
                return false;
            }
            return true;
        }).iterator();
        boolean changed = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            this.fuzzy.remove(key);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        Iterator keys = this.fuzzy.keySet().stream().filter(ts -> {
            for (Object o : collection) {
                if (!this.cutoff.test(ts, o)) continue;
                return true;
            }
            return false;
        }).iterator();
        boolean changed = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            this.fuzzy.remove(key);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.fuzzy.clear();
    }
}

