/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.util;

import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.Timing;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.Nullable;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static @Nullable IoSupplier<InputStream> wrapSafeData(ResourceLocation rl, PathAwareInputStreamSource source, ResourceGenerationContext context) {
        return ResourceUtils.wrapSafeData(rl, source::get, context, i -> i, i -> i, source::createCacheKey);
    }

    public static <T extends AutoCloseable> @Nullable IoSupplier<T> wrapSafeData(ResourceLocation rl, BiFunction<ResourceLocation, ResourceGenerationContext, @Nullable IoSupplier<T>> source, ResourceGenerationContext context, IoFunction<T, InputStream> writer, IoFunction<InputStream, T> opener, BiFunction<ResourceLocation, ResourceGenerationContext, @Nullable String> cacheKeyMaker) {
        Transformer<AutoCloseable> transformer;
        IoSupplier supplier;
        block16: {
            String partialCacheKey;
            supplier = null;
            transformer = is -> is;
            if (DynamicAssetGenerator.getConfig().fullCache()) {
                try {
                    Path path = DynamicAssetGenerator.cache(context.getCacheName(), false).resolve(rl.getNamespace()).resolve(rl.getPath());
                    if (!Files.exists(path.getParent(), new LinkOption[0])) {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    if (Files.exists(path, new LinkOption[0])) {
                        supplier = () -> (AutoCloseable)opener.apply(Files.newInputStream(path, new OpenOption[0]));
                        break block16;
                    }
                    transformer = transformer.andThen(is -> {
                        AutoCloseable autoCloseable;
                        block9: {
                            AutoCloseable stream = is;
                            try {
                                Files.copy((InputStream)writer.apply(stream), path, StandardCopyOption.REPLACE_EXISTING);
                                autoCloseable = (AutoCloseable)opener.apply(Files.newInputStream(path, new OpenOption[0]));
                                if (stream == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    throw new IOException(e);
                                }
                            }
                            stream.close();
                        }
                        return autoCloseable;
                    });
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Could not cache resource {}...", (Object)rl, (Object)e);
                }
            } else if (DynamicAssetGenerator.getConfig().keyedCache() && (partialCacheKey = cacheKeyMaker.apply(rl, context)) != null) {
                String cacheKey = Services.PLATFORM.getModVersion() + ":" + partialCacheKey;
                Path keyPath = DynamicAssetGenerator.cache(context.getCacheName(), true).resolve(rl.getNamespace()).resolve(rl.getPath() + ".dynassetgen");
                Path contentPath = DynamicAssetGenerator.cache(context.getCacheName(), true).resolve(rl.getNamespace()).resolve(rl.getPath());
                try {
                    if (!Files.exists(keyPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(keyPath.getParent(), new FileAttribute[0]);
                    }
                    String existingKey = null;
                    if (Files.exists(keyPath, new LinkOption[0])) {
                        existingKey = Files.readString(keyPath, StandardCharsets.UTF_8);
                    }
                    if (existingKey != null && existingKey.equals(cacheKey)) {
                        supplier = () -> (AutoCloseable)opener.apply(Files.newInputStream(contentPath, new OpenOption[0]));
                    } else {
                        supplier = source.apply(rl, context);
                        transformer = transformer.andThen(is -> {
                            AutoCloseable autoCloseable;
                            block9: {
                                AutoCloseable stream = is;
                                try {
                                    Files.copy((InputStream)writer.apply(stream), contentPath, StandardCopyOption.REPLACE_EXISTING);
                                    Files.writeString(keyPath, (CharSequence)cacheKey, StandardCharsets.UTF_8, new OpenOption[0]);
                                    autoCloseable = (AutoCloseable)opener.apply(Files.newInputStream(contentPath, new OpenOption[0]));
                                    if (stream == null) break block9;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (stream != null) {
                                            try {
                                                stream.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        throw new IOException(e);
                                    }
                                }
                                stream.close();
                            }
                            return autoCloseable;
                        });
                    }
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Could not cache resource {}...", (Object)rl, (Object)e);
                    supplier = source.apply(rl, context);
                }
            }
        }
        if (supplier == null) {
            supplier = source.apply(rl, context);
        }
        if (supplier == null) {
            return null;
        }
        IoSupplier finalSupplier = supplier;
        Transformer<AutoCloseable> finalTransformer = transformer;
        IoSupplier output = () -> {
            try {
                return finalTransformer.transform((AutoCloseable)finalSupplier.get());
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue reading supplying resource {}:", (Object)rl, (Object)e);
                throw new IOException(e);
            }
        };
        if (DynamicAssetGenerator.TIME_RESOURCES) {
            return () -> {
                long startTime = System.nanoTime();
                AutoCloseable result = (AutoCloseable)output.get();
                long endTime = System.nanoTime();
                long duration = (endTime - startTime) / 1000L;
                Timing.recordTime(context.getCacheName().toString(), rl, duration);
                return result;
            };
        }
        return output;
    }

    public static interface IoFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    private static interface Transformer<T extends AutoCloseable> {
        public T transform(T var1) throws IOException;

        default public Transformer<T> andThen(Transformer<T> after) {
            return stream -> after.transform(this.transform(stream));
        }
    }
}

