/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.widget;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiScreenshotRecorder;
import dev.emi.emi.widget.RecipeButtonWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class RecipeScreenshotButtonWidget
extends RecipeButtonWidget {
    public RecipeScreenshotButtonWidget(int x, int y, EmiRecipe recipe) {
        super(x, y, 60, 0, recipe);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        return List.of(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("tooltip.emi.recipe_screenshot"))));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.playButtonSound();
        ResourceLocation id = this.recipe.getId();
        Object path = id == null ? "unknown-recipe" : id.getNamespace() + "/" + id.getPath().replace("/", "_");
        int width = this.recipe.getDisplayWidth() + 8;
        int height = this.recipe.getDisplayHeight() + 8;
        Minecraft client = Minecraft.getInstance();
        GuiGraphics context = new GuiGraphics(client, client.renderBuffers().bufferSource());
        EmiScreenshotRecorder.saveScreenshot("emi/recipes/" + (String)path, width, height, () -> EmiRenderHelper.renderRecipe(this.recipe, EmiDrawContext.wrap(context), 0, 0, false, -1));
        return true;
    }
}

