/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul;

import com.teamresourceful.resourcefulconfig.api.loader.Configurator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import tech.alexnijjar.golemoverhaul.client.GolemOverhaulClient;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.KelpGolem;
import tech.alexnijjar.golemoverhaul.common.network.NetworkHandler;
import tech.alexnijjar.golemoverhaul.common.registry.ModBlocks;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModItems;
import tech.alexnijjar.golemoverhaul.common.registry.ModParticleTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeSerializers;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;

@Mod(value="golemoverhaul")
public class GolemOverhaul {
    public static final String MOD_ID = "golemoverhaul";
    public static final Configurator CONFIGURATOR = new Configurator("golemoverhaul");

    public GolemOverhaul(IEventBus bus) {
        CONFIGURATOR.register(GolemOverhaulConfig.class);
        NetworkHandler.init();
        ModBlocks.BLOCKS.init();
        ModItems.ITEMS.init();
        ModItems.TABS.init();
        ModEntityTypes.ENTITY_TYPES.init();
        ModParticleTypes.PARTICLE_TYPES.init();
        ModSoundEvents.SOUND_EVENTS.init();
        ModRecipeTypes.RECIPE_TYPES.init();
        ModRecipeSerializers.RECIPE_SERIALIZERS.init();
        if (FMLLoader.getDist() == Dist.CLIENT) {
            NeoForge.EVENT_BUS.addListener(GolemOverhaulClient::onClientTick);
        }
        NeoForge.EVENT_BUS.addListener(GolemOverhaul::onFarmlandTrample);
        NeoForge.EVENT_BUS.addListener(GolemOverhaul::onBlockPlace);
    }

    private static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (event.getPlacedBlock().is(Blocks.DRIED_KELP_BLOCK) || event.getPlacedBlock().is(Blocks.SEA_LANTERN)) {
                KelpGolem.trySpawnGolem(level, event.getPos());
            }
        }
    }

    private static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        LevelAccessor level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        AABB bounds = event.getState().getCollisionShape((BlockGetter)level, pos).bounds().move(pos).inflate(10.0);
        if (!level.getEntitiesOfClass(HayGolem.class, bounds).isEmpty()) {
            event.setCanceled(true);
        }
    }
}

