/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class HayGolemRenderer
extends BaseGolemRenderer<HayGolem> {
    public static final ResourceLocation GREEN_TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/hay/green_hay_golem_1.png");
    public static final ResourceLocation GREEN_TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/hay/green_hay_golem_2.png");
    public static final ResourceLocation GREEN_TEXTURE_3 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/hay/green_hay_golem_3.png");
    public static final ResourceLocation RED_TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/hay/red_hay_golem_1.png");
    public static final ResourceLocation RED_TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/hay/red_hay_golem_2.png");
    public static final ResourceLocation RED_TEXTURE_3 = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/entity/hay/red_hay_golem_3.png");
    public static final ResourceLocation GREEN_MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/hay/green_hay_golem.geo.json");
    public static final ResourceLocation SHEARED_GREEN_MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/hay/green_hay_golem_sheared.geo.json");
    public static final ResourceLocation RED_MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/hay/red_hay_golem.geo.json");
    public static final ResourceLocation SHEARED_RED_MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/hay/red_hay_golem_sheared.geo.json");

    public HayGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<HayGolem>(ModEntityTypes.HAY_GOLEM, true, 90){

            public ResourceLocation getModelResource(HayGolem golem) {
                boolean sheared = golem.isSheared();
                return golem.getColor() == HayGolem.Color.GREEN ? (sheared ? SHEARED_GREEN_MODEL : GREEN_MODEL) : (sheared ? SHEARED_RED_MODEL : RED_MODEL);
            }
        });
    }

    public ResourceLocation getTextureLocation(HayGolem golem) {
        HayGolem.Color color = golem.getColor();
        return switch (golem.getCrackiness()) {
            default -> throw new MatchException(null, null);
            case Crackiness.Level.NONE, Crackiness.Level.LOW -> {
                if (color == HayGolem.Color.GREEN) {
                    yield GREEN_TEXTURE_1;
                }
                yield RED_TEXTURE_1;
            }
            case Crackiness.Level.MEDIUM -> {
                if (color == HayGolem.Color.GREEN) {
                    yield GREEN_TEXTURE_2;
                }
                yield RED_TEXTURE_2;
            }
            case Crackiness.Level.HIGH -> color == HayGolem.Color.GREEN ? GREEN_TEXTURE_3 : RED_TEXTURE_3;
        };
    }
}

