/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class CoalGolem
extends BaseGolem {
    public static final int DEATH_TICKS = 13;
    public static final int MAX_SUMMON_TICKS = 2400;
    private static final EntityDataAccessor<Boolean> ID_LIT = SynchedEntityData.defineId(CoalGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean summoned;
    @Nullable
    private UUID summonerId;

    public CoalGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 1;
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnCoalGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        if (level.getBiome(pos).is(Biomes.DEEP_DARK)) {
            return false;
        }
        return pos.getY() < level.getSeaLevel() && !level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK) && Mob.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController((GeoAnimatable)this, "death_controller", 5, state -> {
            if (this.deathTime == 0) {
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.DIE);
        }));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LIT, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Lit", this.isLit());
        if (this.summonerId != null) {
            compound.putUUID("SummonerId", this.summonerId);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setLit(compound.getBoolean("Lit"));
        if (compound.hasUUID("SummonerId")) {
            this.setSummoner(compound.getUUID("SummonerId"));
        }
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
    }

    @Override
    public boolean canTarget() {
        return this.isLit() || this.isSummoned();
    }

    public boolean isLit() {
        return (Boolean)this.entityData.get(ID_LIT);
    }

    public void setLit(boolean lit) {
        this.entityData.set(ID_LIT, (Object)lit);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(lit ? 12.0 : 2.0);
        this.updateAttackGoals();
    }

    public boolean isSummoned() {
        return this.summoned;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoned = summoner != null;
        this.summonerId = summoner;
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource source) {
        if (this.isSummoned()) {
            return;
        }
        super.dropAllDeathLoot(level, source);
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.isLit() || this.deathTime >= 13 && !this.level().isClientSide() && !this.isRemoved()) {
            this.removeAndAddDeathParticles();
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.isLit() ? (SoundEvent)ModSoundEvents.COAL_GOLEM_AMBIENT.get() : super.getAmbientSound();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return this.isLit() ? (SoundEvent)ModSoundEvents.COAL_GOLEM_HURT.get() : super.getHurtSound(damageSource);
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.isLit() ? (SoundEvent)ModSoundEvents.COAL_GOLEM_DEATH.get() : super.getDeathSound();
    }

    @Override
    public Crackiness.Level getCrackiness() {
        return Crackiness.Level.NONE;
    }

    @Override
    public boolean shouldAttack(LivingEntity entity) {
        if (entity instanceof Creeper) {
            return this.isLit();
        }
        return super.shouldAttack(entity);
    }

    public void lavaHurt() {
        super.lavaHurt();
        this.setLit(true);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.IS_FIRE)) {
            this.setLit(true);
        }
        return super.hurt(source, amount);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public int getAttackTicks() {
        return 10;
    }

    @Override
    public Item getRepairItem() {
        return Items.COAL;
    }

    @Override
    public float getRepairItemHealAmount() {
        return this.getMaxHealth();
    }

    public void extinguishFire() {
        super.extinguishFire();
        if (this.isLit()) {
            this.setLit(false);
            this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE);
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + this.random.nextGaussian() * 0.3, this.getY() + 0.5 + this.random.nextGaussian() * 0.3, this.getZ() + this.random.nextGaussian() * 0.3, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean doHurtTarget(@NotNull Entity target) {
        if (super.doHurtTarget(target)) {
            if (this.isLit() && !this.level().isClientSide()) {
                target.igniteForSeconds(5.0f);
                this.kill();
                this.deathTime = 10;
                this.playSound((SoundEvent)ModSoundEvents.COAL_GOLEM_EXPLODE.get());
                for (int i = 0; i < 10; ++i) {
                    ModUtils.sendParticles((ServerLevel)this.level(), ParticleTypes.FLAME, this.getX() + this.random.nextGaussian() * 0.3, this.getY() + 0.5 + this.random.nextGaussian() * 0.3, this.getZ() + this.random.nextGaussian() * 0.3, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity summoner;
            ServerLevel level2 = (ServerLevel)level;
            if (this.tickCount > 2400 && this.isSummoned()) {
                this.kill();
                this.playSound((SoundEvent)ModSoundEvents.COAL_GOLEM_EXPLODE.get());
            }
            if (this.summonerId != null && (summoner = level2.getEntity(this.summonerId)) instanceof Mob) {
                Mob mob = (Mob)summoner;
                this.setTarget(mob.getTarget());
            }
        }
        super.tick();
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (super.mobInteract(player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (this.isLit()) {
            if (stack.isEmpty()) {
                this.extinguishFire();
                return InteractionResult.SUCCESS;
            }
        } else {
            if (stack.is(Items.FLINT_AND_STEEL)) {
                stack.hurtAndBreak(1, (LivingEntity)player, CoalGolem.getSlotForHand((InteractionHand)hand));
                this.playSound(SoundEvents.FLINTANDSTEEL_USE);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
            if (stack.is(Items.FIRE_CHARGE)) {
                stack.shrink(1);
                this.playSound(SoundEvents.FIRECHARGE_USE);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.0, 0.0, 1.0);
    }
}

